package com.sap.caf.rt.services.notify.notif.send;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.notif.INotifSender;
import com.sap.caf.rt.services.notify.notif.NotifException;
import com.sap.caf.rt.services.notify.res.IResourceKeys;
import com.sap.caf.rt.services.notify.subscr.ISubscrPrefs;
import com.sap.caf.rt.services.notify.subscr.ISubscrTemplate;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrPrefsFactory;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrPrefsFactory;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class NotifSender implements INotifSender {

	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationSender#send(java.util.Collection, com.sap.caf.rt.services.notify.notification.INotificationTemplate, java.util.Map)
	 */
	public void send(Collection userIds, ISubscription subscr, INotifEvent event) throws NotifException {
		try {
			IUser user = event.getOriginator();
			String originator = user != null ? user.getUniqueID() : null;
			ISubscrTemplate templ = subscr.getTemplate();
			String templId = templ.getId();
			String templSubj = templ.getLocalizedSubject();
			Properties templProps = templ.getProperties(event);
			if (Log.isDebugEnabled()) {
				Log.debug("users:[{0}],id:[{1}],subj:[{2}],props:[{3}]", new Object[] { userIds, templId, templSubj, templProps });
			}
			Collection notifRecips = createNotifRecipients((IPersistSubscription) subscr, userIds);
			if (notifRecips == null || notifRecips.isEmpty()) {
				if (Log.isDebugEnabled()) {
					Log.debug("There is nobody to send the message to. All users are unsibscribed");
				}
				return;
			}
			NotifMessage notifMsg = new NotifMessage(originator, notifRecips, templId, templSubj, templProps);
			if (!notifMsg.isValid()) {
				if (Log.isDebugEnabled()) {
					Log.debug("NotifMessage is invalid, not sending");
				}
			}
			getSendingBean().send(notifMsg);
		} catch (Exception e) {
			NotifException notifEx = new NotifException(IResourceKeys.CANT_PUBLISH_MSG, e);
			throw notifEx;
		}
	}

	protected Collection createNotifRecipients(IPersistSubscription subscr, Collection userIds) throws PersistException {
		IPersistSubscrPrefsFactory prefFactory = PersistSubscrPrefsFactory.getInstance();
		List notifRecips = new ArrayList();
		String userId;
		IUser user;
		ISubscrPrefs subscrPref;
		for (Iterator itr = userIds.iterator(); itr.hasNext();) {
			userId = (String) itr.next();
			user = getUser(userId);
			if (user == null) {
				continue;
			}
			subscrPref = prefFactory.getSubscrPrefs(subscr, user);
			if (subscrPref != null && !subscrPref.isSubscribed()) {
				Log.info(IResourceKeys.UNSUBSCR_USER, new Object[] { userId });
				continue;
			}
			notifRecips.add(new NotifRecipient(user, subscrPref));
		}
		return notifRecips;
	}

	private IUser getUser(String userId) {
		if (userId == null) {
			return null;
		}
		IUserFactory userFactory = UMFactory.getUserFactory();
		IUser user = null;
		// try to find user by unique id
		try {
			user = userFactory.getUser(userId);
		} catch (UMException e) {
			if (Log.isDebugEnabled()) {
				Log.debug("Couldn't find user by unique id:[" + userId + "], try to find by logon id, cause:[" + e.getMessage() + "]");
			}
		}
		if (user == null) {
			// try to find user by logon id
			try {
				user = userFactory.getUserByLogonID(userId);
			} catch (UMException e) {
				Log.fatal(IResourceKeys.CANT_GET_USER, new Object[] { userId }, e);
			}
		}
		return user;
	}

	protected SendingLocal getSendingBean() throws NamingException, CreateException {
		if (m_sendingHome == null) {
			Context context = new InitialContext();
			m_sendingHome = (SendingLocalHome) context.lookup(JNDI_SENDBEAN_NAME);
		}
		return m_sendingHome.create();
	}

	private SendingLocalHome m_sendingHome;
	private final static String JNDI_SENDBEAN_NAME = "localejbs/sap.com/caf.runtime/Sending";
}