package com.sap.caf.rt.services.notify.notif.send;

import java.io.Serializable;

import com.sap.caf.rt.services.notify.subscr.ISubscrPrefs;
import com.sap.security.api.IUser;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class NotifRecipient implements Serializable {
	static final long serialVersionUID = 1;

	public NotifRecipient() {
	}
	
	public NotifRecipient(IUser user, ISubscrPrefs prefs) {
		setUserId(user.getUniqueID());
		if (prefs!=null) {
			setNotifEnabled(prefs.isSubscribed());
			setActionInboxEnabled(prefs.isActionInboxEnabled());
		}
	}
	
	public boolean isNotifEnabled() {
		return m_bNotifEnabled;
	}
	
	public void setNotifEnabled(boolean enabled) {
		m_bNotifEnabled = enabled;
	}
	
	public boolean isActionInboxEnabled() {
		return m_bActionInboxEnabled; 
	}
	
	public void setActionInboxEnabled(boolean enabled) {
		m_bActionInboxEnabled = enabled; 
	}
	
	public String getUserId() {
		return m_sUserId; 
	}
	
	public void setUserId(String userId) {
		m_sUserId = userId;
	}
	
	protected boolean m_bNotifEnabled = true;
	protected boolean m_bActionInboxEnabled = true; // TODO init from CAFContext
	protected String m_sUserId;

}
