package com.sap.caf.rt.services.notify.notif.send;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class NotifMessage implements Serializable {
	static final long serialVersionUID = 1;

	public NotifMessage() {
	}
	
	public NotifMessage(String originator, Collection recipients, String templKey, String subject, Properties params) {
		setCreatedAt(new Date());
		setOriginator(originator);
		setRecipients(recipients);
		setTemplateId(templKey);
		setSubject(subject);
		setParameters(params);
	}

	public void setOriginator(String originator) {
		m_originator = originator;
	}

	public String getOriginator() {
		return m_originator;
	}

	public void setCreatedAt(Date date) {
		m_createdAt = date;
	}

	public Date getCreatedAt() {
		return m_createdAt; 
	}

	public void setTemplateId(String templId) {
		m_templId = templId;
	}
	
	public String getSubject() {
		return m_subject;	
	}
	
	public void setSubject(String subject) {
		m_subject = subject;
	}
	
	public String getTemplateId() {
		return m_templId;	
	}
	
	public Collection getRecipients() {
		return m_recips; 
	}

	public void setRecipients(Collection recipients) {
		m_recips = recipients;	
	}
	
	public Properties getParameters() {
		return m_params;
	}
	
	public void setParameters(Properties params) {
		m_params=params;
	}
	
	boolean isValid() {
		return !(m_recips==null || m_recips.isEmpty() || m_templId==null);
	}
	
	private Collection m_recips;
	private String m_originator;
	private String m_templId;
	private String m_subject;
	private Properties m_params;
	private Date m_createdAt;
}
