package com.sap.caf.rt.services.notify.notif.bobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.services.notify.notif.NotifEvent;
import com.sap.caf.rt.services.notify.subscr.ISubscrType;
import com.sap.caf.rt.services.notify.subscr.bobject.BOSubscrType;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class ChangedEvent extends NotifEvent implements IChangedEvent {

	public ChangedEvent(String subscrId, ISubscrType type) {
		this(subscrId, type, null);
	}
	
	public ChangedEvent(String subscrId, ISubscrType type, Map attrs) {
		super(subscrId, type, attrs);
	}

	public void registerOldValue(String attrName, Object value) {
		if (value==null || BOSubscrType.CREATED.equals(getType())) {
			return;
		}
		String attrKey=NS_OLD+attrName;
		if (getAttribute(attrKey)==null)  {
			if (value instanceof Collection) {
				value = new ArrayList((Collection)value); 
			}
			else if (value instanceof IDependentObject) {
				value = BOUtils.cloneDependentObject((IDependentObject)value);
			}
			setAttribute(attrKey, value);
		}
	}
	
	public void registerNewValue(String attrName, Object value) {
		setAttribute(NS_NEW+attrName, value);
	}
	
	public void registerOldValue(String attrName, int number) {
		registerOldValue(attrName, new Integer(number));
	}

	public void registerNewValue(String attrName, int number) {
		registerNewValue(attrName, new Integer(number));
	}
	
	public void registerOldValue(String attrName, boolean bool) {
		registerOldValue(attrName, Boolean.valueOf(bool));
	}

	public void registerNewValue(String attrName, boolean bool) {
		registerNewValue(attrName, Boolean.valueOf(bool));
	}

	public Object getOldValue(String attrName) {
		return getAttribute(NS_OLD+attrName);
	}

	public Object getNewValue(String attrName) {
		return getAttribute(NS_NEW+attrName);
	}
}
