package com.sap.caf.rt.services.notify.notif.bobject;

import java.util.List;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.services.notify.common.Log;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class BOUtils {

	public static String convertObjType(String objType) {
		char[] chars = objType.toCharArray();
		int len = FORBIDDEN_CHARS.length;
		for (int i = chars.length; --i >= 0;) {
			for (int j = len; --j >= 0;) {
				if (chars[i] == FORBIDDEN_CHARS[j]) {
					chars[i] = NAME_DELIM;
					break;
				}
			}
		}
		return new String(chars);
	}

	public static IDependentObject cloneDependentObject(IDependentObject obj) {
		if (obj == null) {
			return null;
		}
		try {
			IDependentObject clone = (IDependentObject) obj.getClass().newInstance();
			List propKeys = obj.getPropertyList();
			String propKey;
			for (int i = propKeys.size(); --i >= 0;) {
				propKey = (String) propKeys.get(i);
				clone.setProperty(propKey, obj.getProperty(propKey));
			}
			return clone;
		} catch (Exception e) {
			Log.fatal(e);
			return null;
		}
	}

	private final static char ACT_DELIM = '%';
	private final static char NAME_DELIM = '-';
	private final static char[] FORBIDDEN_CHARS = { '/', '.', ':', '\\', '"', '\'' };
}
