package com.sap.caf.rt.services.notify.notif.bobject;

import java.lang.reflect.Method;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.IKMExt;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.GroupNotifDispatcher;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.notif.NotifException;
import com.sap.caf.rt.services.notify.res.IResourceKeys;
import com.sap.caf.rt.services.notify.subscr.ISubscrType;
import com.sap.caf.rt.services.notify.subscr.bobject.BOSubscrType;
import com.sap.caf.rt.services.publish.PublishingLocal;
import com.sap.caf.rt.services.publish.PublishingLocalHome;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class BOChangedPublisher extends GroupNotifDispatcher {

	public BOChangedPublisher(Object ibo) {
	}

	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationDispatcher#notify(com.sap.caf.rt.services.notify.notification.INotificationEvent)
	 */
	public void notify(INotifEvent event) throws NotifException {
		if (CAFContext.PUBLISH_ENABLED && event.isEnabled()) {
			publish((BOChangedEvent) event);
			super.notify(event);
		}
	}

	protected void publish(BOChangedEvent event) throws NotifException {
		final String method = "publish(BOChangedEvent)";
		Log.enter(method, new Object[] { event });
		try {
			PublishingLocal pub = getPublishService();
			Object[] args = createPublishingArgs(event.getSource());
			ISubscrType eventType = event.getType();
			if (eventType.equals(BOSubscrType.CREATED)) {
				pub.publishCreated(args);
			} else if (eventType.equals(BOSubscrType.UPDATED)) {
				pub.publishChanged(args);
			} else if (eventType.equals(BOSubscrType.DELETED)) {
				pub.publishRemoved(args);
			}
		} catch (Exception e) {
			NotifException ownEx = new NotifException(IResourceKeys.CANT_PUBLISH_DATA, e);
			Log.fatal(ownEx, method);
			throw ownEx;
		} finally {
			Log.exit(method);
		}
	}

	protected Object[] createPublishingArgs(IDependentObject ibo) throws Exception {
		Object[] msgArgs = new Object[5];
		msgArgs[0] = ibo.getObjectType();
		msgArgs[1] = ibo.getKey();
		msgArgs[2] = getRid(ibo);
		msgArgs[3] = "";
		if (ibo instanceof IKMExt) {
			Iterator it = ((IKMExt) ibo).getRelatedObjectRids().iterator();
			if (it.hasNext()) {
				StringBuffer buffer = new StringBuffer();
				do {
					buffer.append((String) it.next()).append(';');
				} while (it.hasNext());
				buffer.setLength(buffer.length() - 1);
				msgArgs[3] = buffer.toString();
			}
		}
		return msgArgs;
	}

	private String getRid(IDependentObject ibo) {
		try {
			Method method = ibo.getClass().getMethod("getRid", new Class[] {
			});
			return (String) method.invoke(ibo, new Object[] {
			});
		} catch (Exception e) {
			if (Log.isDebugEnabled()) {
				Log.debug("Method getRid() is not exists for given IDependedObject", e);
			}	
			return "";
		}
	}

	private synchronized PublishingLocal getPublishService() throws NamingException, CreateException, BEException {
		if (m_pubHome == null) {
			Context ctx = new InitialContext();
			m_pubHome = (PublishingLocalHome) ctx.lookup("localejbs/sap.com/caf.runtime/Publishing");
		}
		return m_pubHome.create();
	}

	private PublishingLocalHome m_pubHome;

}
