package com.sap.caf.rt.services.notify.notif;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.common.NSBaseException;
import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.ISubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.deployed.DeployedSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.app.registered.RegisteredSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class RegisteredNotifDispatcher extends NotifDispatcher {

	/**
	 * @see com.sap.caf.rt.services.notify.notif.NotifDispatcher#getSubscrListFactory()
	 */
	protected ISubscrListFactory getSubscrListFactory() throws SubscrException {
		return CAFContext.NOTIF_USE_DEPLOYED_SUBSCR? 
			(ISubscrListFactory)DeployedSubscrListFactory.getInstance(): 
			(ISubscrListFactory)RegisteredSubscrListFactory.getInstance(); 
	}

	/**
	 * @see com.sap.caf.rt.services.notify.notif.NotifDispatcher#fireOnBeforeSend(com.sap.caf.rt.services.notify.subscr.ISubscription, com.sap.caf.rt.services.notify.notif.INotifEvent)
	 */
	protected void fireOnBeforeSend(ISubscription subscr, INotifEvent event) throws NSBaseException {
		event.setAttribute(INotifEvent.APP_PROPS, ((IPersistSubscription)subscr).getApplication().getProperties());
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.notif.NotifDispatcher#getSubscriptions(com.sap.caf.rt.services.notify.subscr.ISubscrList, com.sap.caf.rt.services.notify.notif.INotifEvent)
	 */
	protected Iterator getSubscriptions(ISubscrList subscrList, INotifEvent event) throws SubscrException {
		String subscrId = event.getId();
		ISubscription subscr = subscrList.getSubscription(subscrId);
		if (subscr==null) {
			if (Log.isDebugEnabled()) {
				Log.debug("Could not find subscription by id:[{0}]", new Object[] {subscrId});
			}
			return null;
		}
		List list = new ArrayList(1);
		list.add(subscr);
		return list.iterator();
	}

}
