/* Generated by Together */

package com.sap.caf.rt.services.notify.notif;

import java.util.HashMap;
import java.util.Map;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.common.ServerUtils;
import com.sap.caf.rt.services.notify.res.IResourceKeys;
import com.sap.caf.rt.services.notify.subscr.ISubscrType;
import com.sap.security.api.IUser;

public class NotifEvent implements INotifEvent {

	public NotifEvent(String subscrId, ISubscrType type, Map attrs) {
		m_subscrId = subscrId;
		m_type = type;
		m_attrs = attrs;
		try {
			m_originator = ServerUtils.getCurrentUser(getClass().getClassLoader());
		}
		catch (Exception e) {
			Log.fatal(IResourceKeys.CANT_GET_LOGGED_USER, null, e);			
		}
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationEvent#getSubscriptionId()
	 */
	public String getId() {
		return m_subscrId;
	}

	public void setSubscriptionId(String subscrId) {
		m_subscrId = subscrId;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationEvent#getType()
	 */
	public ISubscrType getType() {
		return m_type;
	}

	public void setType(ISubscrType type) {
		m_type = type;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationEvent#getAttributes()
	 */
	public Map getAttributes() {
		return m_attrs;
	}
	
	public void setAttributes(Map attrs) {
		m_attrs = attrs;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationEvent#setAttribute(java.lang.Object, java.lang.Object)
	 */
	public void setAttribute(Object key, Object value) {
		if (m_attrs==null) {
			m_attrs = new HashMap();
		}
		if (value==null) {
			if (m_attrs.containsKey(key)) {
				m_attrs.remove(key);
			}
		}
		else {
			m_attrs.put(key, value);
		}
	}

	/**
	 * @see com.sap.caf.rt.services.notify.notification.INotificationEvent#getAttribute(java.lang.Object)
	 */
	public Object getAttribute(Object key) {
		return (m_attrs!=null? m_attrs.get(key): null);
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.notif.INotifEvent#isEnabled()
	 */
	public boolean isEnabled() {
		return m_bEnabled;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.notif.INotifEvent#setEnabled(boolean)
	 */
	public void setEnabled(boolean enabled) {
		m_bEnabled = enabled;
	}
	
	/**
	 * @see com.sap.caf.rt.services.notify.notif.INotifEvent#getOriginator()
	 */
	public IUser getOriginator() {
		return m_originator;
	}
	
	protected ISubscrType m_type;
	protected String m_subscrId;
	protected Map m_attrs;
	protected IUser m_originator;
	protected boolean m_bEnabled = true;
}
