package com.sap.caf.rt.services.notify.notif;

import java.util.Iterator;

import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.ISubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.IGeneralSubscrList;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class GroupNotifDispatcher extends RegisteredNotifDispatcher {

	/**
	 * @see com.sap.caf.rt.services.notify.notification.NotifDispatcher#getSubscriptions(com.sap.caf.rt.services.notify.subscription.ISubscrList, com.sap.caf.rt.services.notify.notification.INotifEvent)
	 */
	protected Iterator getSubscriptions(ISubscrList subscrList, INotifEvent event) throws SubscrException {
		return ((IGeneralSubscrList)subscrList).getSubscrByGroup(event.getId());
	}

	/**
	 * @see com.sap.caf.rt.services.notify.notif.INotifDispatcher#isSubscrAvailable(java.lang.String)
	 */
	public boolean isSubscrAvailable(String subscrId) throws SubscrException {
		ISubscrListFactory factory = getSubscrListFactory();
		if (factory==null) {
			return false;
		}
		IGeneralSubscrList subscrList = (IGeneralSubscrList)factory.getSubscrList(); 
		return subscrList.getSubscrByGroup(subscrId).hasNext();
	}

}
