package com.sap.caf.rt.services.notify.notif;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import com.sap.caf.rt.services.notify.common.JndiUtils;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.common.NSBaseException;
import com.sap.caf.rt.services.notify.res.IResourceKeys;
import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.ISubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.AppSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistApplication;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.services.deploy.DeployService;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class AppNotifDispatcher extends NotifDispatcher {

	protected Iterator getSubscriptions(ISubscrList subscrList, INotifEvent event) throws SubscrException {
		String subscrId = event.getId();
		ISubscription subscr = subscrList.getSubscription(subscrId);
		if (subscr == null) {
			if (Log.isDebugEnabled()) {
				Log.debug("Could not find subscription by id:[{0}]", new Object[] {subscrId});
			}
			return null;
		}
		Collection retSubscrList = new ArrayList();
		retSubscrList.add(subscr);
		return retSubscrList.iterator(); 
	}
	
	protected ISubscrListFactory getSubscrListFactory() throws SubscrException {
		synchronized(this) {
			if (m_subscrListFactory==null) {
				m_subscrListFactory=AppSubscrListFactory.getInstance(getApplication());
			}
		}
		return m_subscrListFactory;
	}

	/**
	 * @see com.sap.caf.rt.services.notify.notif.NotifDispatcher#fireOnBeforeSend(com.sap.caf.rt.services.notify.subscr.ISubscription, com.sap.caf.rt.services.notify.notif.INotifEvent)
	 */
	protected void fireOnBeforeSend(ISubscription subscr, INotifEvent event) throws NSBaseException {
		event.setAttribute(INotifEvent.APP_PROPS, getApplication().getProperties());
	}
	
	public synchronized IPersistApplication getApplication() throws SubscrException {
		if (m_app==null) {
			try {
				ClassLoader runtimeLoader = getClass().getClassLoader();
				DeployService deplSrv = (DeployService)JndiUtils.getDeployService(runtimeLoader);
				ComponentExecutionContext appCtx = JndiUtils.getAppContext(runtimeLoader);
				String appName = appCtx.getApplicationName();
				m_app = new PersistApplication(appName);
				m_app.invalidate();
			}
			catch (Exception e) {
				throw new SubscrException(IResourceKeys.CANT_GET_APP, e);
			}
		}
		else {
			if (!m_app.isValid()) {
				try {
					m_app.invalidate();
				}
				catch (PersistException e) {
					throw new SubscrException(IResourceKeys.CANT_GET_APP, e);
				}
			}
		}
		return m_app;
	}
	
	protected IPersistApplication m_app;
	private ISubscrListFactory m_subscrListFactory;
}
