package com.sap.caf.rt.services.notify.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import com.sap.localization.ResourceAccessor;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public class NSResourceAccessor extends ResourceAccessor {
	static final long serialVersionUID = 1;

	public NSResourceAccessor(String bundleName, ClassLoader classLoader) {
		super(bundleName);
		setClassLoader(classLoader);
	}
	
	public NSResourceAccessor(String bundleName) {
		this(bundleName, null);
	}

	public static synchronized ResourceAccessor getInstance(String bundleName) {
		ResourceAccessor accessor = (ResourceAccessor)m_accessors.get(bundleName);
		if (accessor==null) {
			accessor = new NSResourceAccessor(bundleName);
			m_accessors.put(bundleName, accessor);
		}
		return accessor;
	}
	
	public static synchronized ResourceAccessor getInstance(String bundleName, ClassLoader classLoader) {
		NSResourceAccessor accessor = (NSResourceAccessor)m_accessors.get(bundleName);
		if (accessor==null || !classLoader.equals(accessor.getClassLoader())) {
			accessor = new NSResourceAccessor(bundleName, classLoader);
			m_accessors.put(bundleName, accessor);
		}
		return accessor;
	}
	
	protected void setClassLoader(ClassLoader classLoader) {
		m_classLoader = classLoader; 
	}
	protected ClassLoader getClassLoader() {
		return m_classLoader!=null? m_classLoader: getClass().getClassLoader();
	}

	/**
	 * @see com.sap.localization.ResourceAccessor#getMessageText(java.util.Locale, java.lang.String)
	 */
	public String getMessageText(Locale locale, String key) {
		String message = null;
		if(locale == null) {
			locale = Locale.getDefault();
		}
		String bundleName = getResourceBundleName(); 
		if(bundleName==null || key == null) {
			return null; 
		}
		Map bundles = getBundles();
		synchronized(m_bundles) {
			ResourceBundle rb = (ResourceBundle)m_bundles.get(locale);
			if(rb == null) {
				try {
					rb = ResourceBundle.getBundle(bundleName, locale, getClassLoader());
					if(rb != null) {
						message = rb.getString(key);
						bundles.put(locale, rb);
					}
				}
				catch (MissingResourceException e) {
					if (Log.isDebugEnabled()) {
						Log.debug("Could not get bundle:"+bundleName, e);
					}
				}
			} else {
				message = rb.getString(key);
			}
		}
		return message!=null? message: super.getMessageText(locale, key);
	}

	protected synchronized Map getBundles() {
		if (m_bundles==null) {
			m_bundles = new HashMap(5);
		}
		return m_bundles; 
	}
	
	protected transient Map m_bundles;
	protected transient ClassLoader m_classLoader;
	private static final Map m_accessors = new HashMap();
}
