package com.sap.caf.rt.services.notify.common;

import java.io.PrintWriter;
import java.io.StringWriter;

import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Severity;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public final class Log {

	private final static String JARM_REQUEST = "CAF:RT:notify";
	
	public static void exit(String method) {
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, CAFPublicLogger.LOC_CAF);
	}

	public static void enter(String method) {
		CAFPublicLogger.entering(null, JARM_REQUEST, method, CAFPublicLogger.LOC_CAF);
	}

	public static void enter(String method, Object[] params) {
		CAFPublicLogger.entering(null, JARM_REQUEST, method, CAFPublicLogger.LOC_CAF);
	}
	
	public static void fatal(Throwable e, String method) {
		CAFPublicLogger.categoryCAF.logThrowableT(Severity.ERROR, CAFPublicLogger.LOC_CAF, method, e);
	}
	
	public static void fatal(String msgKey, Object[] args) {
		CAFPublicLogger.LOC_CAF.fatalT(getLocalizedMessage(msgKey, args));
	}

	public static void fatal(Throwable e) {
		CAFPublicLogger.categoryCAF.logThrowableT(Severity.ERROR, CAFPublicLogger.LOC_CAF, null, e);
	}
	
	public static void fatal(String msgKey, Object[] args, Throwable e) {
		fatal(msgKey, args);
		fatal(e);
	}
	
	public static void debug(String msg) {
		CAFPublicLogger.LOC_CAF.debugT(msg);
	}

	public static void info(String msgKey, Object[] args) {
		CAFPublicLogger.LOC_CAF.infoT(getLocalizedMessage(msgKey, args));
	}
	
	public static void debug(String msg, Object[] args) {
		CAFPublicLogger.LOC_CAF.debugT(msg, args);
	}
	
	public static void debug(String msg, Throwable e) {
		StringWriter writer = new StringWriter();
		PrintWriter wrapper = new PrintWriter(writer);
		e.printStackTrace(wrapper);
		wrapper.close();
		CAFPublicLogger.LOC_CAF.debugT(msg, writer.toString());
	}
	
	public static boolean isDebugEnabled() {
		return CAFPublicLogger.LOC_CAF.beDebug();
	}

	public static boolean isInfoEnabled() {
		return CAFPublicLogger.LOC_CAF.beInfo();
	}
	
	private static String getLocalizedMessage(String msgKey, Object[] args) {
		String msg;
		try {
			LocalizableTextFormatter formatter =
				new LocalizableTextFormatter(NSResourceAccessor.getInstance(NSBaseException.BUNDLENAME),
					msgKey, args);
			msg = formatter.format();
		} catch (Exception e) {
			fatal(e);
			msg = msgKey;
		}
		return msg;
	}
 
}