package com.sap.caf.rt.services.notify.common;

import java.lang.reflect.Method;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ApplicationClusterContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.core.CoreContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.lib.security.SecurityContext;
import com.sap.engine.services.configuration.appconfiguration.impl.ApplicationConfigHandlerFactoryImpl;
import com.sap.engine.services.deploy.ApplicationInformation;
import com.sap.engine.services.deploy.DeployService;

/**
 * @author viachaslau_kudzinau@epam.com
 */
public final class JndiUtils {

	public static ComponentExecutionContext getAppContext(ClassLoader classLoader) throws Exception { 
		return (ComponentExecutionContext)getServiceContext(classLoader).getContainerContext().getObjectRegistry().getProvidedInterface("appcontext");
	}
	
	public static ApplicationServiceContext getServiceContext(ClassLoader classLoader) throws Exception {
		Object objIWebDynproRuntimeService = getJndiObject("webdynpro", classLoader);
		Class clIWebDynproRuntimeService = objIWebDynproRuntimeService.getClass();
		Method mthGetGlobalApplicationContext = clIWebDynproRuntimeService.getMethod("getGlobalApplicationContext", new Class[]{});
		return (ApplicationServiceContext)mthGetGlobalApplicationContext.invoke(objIWebDynproRuntimeService, new Object[] {});
	}
	
	public static DeployService getDeployService(ClassLoader classLoader) throws Exception {
		return (DeployService)getServiceContext(classLoader).getContainerContext().getObjectRegistry().getProvidedInterface("container");
	}

	public static CoreContext getCoreContext(ClassLoader classLoader) throws Exception {
		return getServiceContext(classLoader).getCoreContext();
	}

	public static SecurityContext getSecurityContext(ClassLoader classLoader) throws Exception {
		ThreadSystem threadSystem = getServiceContext(classLoader).getCoreContext().getThreadSystem();
		int securityContextObjectId = threadSystem.getContextObjectId("security");
		return (SecurityContext)threadSystem.getThreadContext().getContextObject(securityContextObjectId);
	}
	
	public static ThreadContext getThreadContext(ClassLoader classLoader) throws Exception {
		return getServiceContext(classLoader).getCoreContext().getThreadSystem().getThreadContext();
	}
	
	public static ApplicationClusterContext getClusterContext(ClassLoader classLoader) throws Exception {
		return getServiceContext(classLoader).getClusterContext();
	}
	
	public static String getClusterElementName(ClassLoader classLoader) throws Exception {
		ClusterElement serverInfo = getClusterContext(classLoader).getClusterMonitor().getCurrentParticipant();
		return serverInfo!=null?	serverInfo.getName(): null;
	}
	
	public static ConfigurationHandler getConfigHandler(ClassLoader classLoader) throws Exception {
		return getServiceContext(classLoader).getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
	}

	public static Object getJndiObject(String name, ClassLoader classLoader) throws NamingException {
		final ClassLoader oldLoader = Thread.currentThread().getContextClassLoader(); 
		try {
			Thread.currentThread().setContextClassLoader(classLoader);
			Context ctx = new InitialContext();
			return ctx.lookup(name);
		}
		finally {
			Thread.currentThread().setContextClassLoader(oldLoader);
		}
	}

	public static ClassLoader getAppClassLoader(ClassLoader classLoader, String appId) throws Exception {
		return JndiUtils.getCoreContext(classLoader).getLoadContext().getClassLoader(appId);
	}
	

	public static Properties getAppProperties(ClassLoader classLoader, String appId) throws Exception {
		ApplicationServiceContext appCtx = getServiceContext(classLoader);
		CoreContext coreCtx = appCtx.getCoreContext();
		LoadContext loadCtx = coreCtx.getLoadContext();
		DeployService deplSrv = (DeployService)appCtx.getContainerContext().getObjectRegistry().getProvidedInterface("container");
		ApplicationInformation appInfo = deplSrv.getApplicationInformation(appId);
		String appConfigPath = appInfo.getApplicationConfigurationPath()+"/"+
				ApplicationConfigHandlerFactoryImpl.APPLICATION_GLOBAL_PROPERTIES;
		ConfigurationHandler configHandler = coreCtx.getConfigurationHandlerFactory().getConfigurationHandler();
		try {
			Configuration config = configHandler.openConfiguration(appConfigPath, ConfigurationHandler.READ_ACCESS);
			try {
				PropertySheet propSheet = config.getPropertySheetInterface();
				return propSheet!=null? propSheet.getProperties(): null;
			}
			finally {
				configHandler.closeConfiguration(config);
			}
		}
		catch (NameNotFoundException e) {
			if (Log.isDebugEnabled()) {
				Log.debug("App:["+appId+"] does not contain config:["+appConfigPath+"]");
			}
			return null;
		}
	}
}
