package com.sap.caf.rt.services.metadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
/**
 * @ejbHome <{com.sap.caf.rt.services.metadata.MetaDataHome}>
 * @ejbLocal <{com.sap.caf.rt.services.metadata.MetaDataLocal}>
 * @ejbLocalHome <{com.sap.caf.rt.services.metadata.MetaDataLocalHome}>
 * @ejbRemote <{com.sap.caf.rt.services.metadata.MetaData}>
 * @stateless 
 */
public class MetaDataBean implements SessionBean {
	private static final long serialVersionUID = 1;
	
	private transient MetaModel mmr = null;
	private static final String APPLICATION = MetaDataBean.class.getName();
	private static final String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
	private static final Location location =
		Location.getLocation(MetaDataBean.class);

	public void ejbRemove() {
		mmr = null;
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setSessionContext(SessionContext context) {
		myContext = context;
	}

	private transient SessionContext myContext;
	/**
	 * Create Method.
	 */
	public void ejbCreate() throws CreateException {
		String method = "ejbCreate()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);

		try {
			mmr = new MetaModel();
		} catch (Exception ex) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in ejbCreate of mmr MetaModel",
				ex);
			location.throwing(method, ex);
			throw new CreateException(ex.getMessage());	// $JL-EXC$
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	/**
	 * Business Method.
	 */
	public Map getAttributeNames(String qualifiedName)
		throws ServiceException {
		Map col = new HashMap();
		String method = "getAttributeNames(String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { qualifiedName },
			CAFPublicLogger.LEVEL_MEDIUM);

		try {
			col = mmr.getAttributes(qualifiedName);
		} catch (DataAccessException e) {
			location.throwing(method, e);
			throw new ServiceException("MMR_QUERY", new Object[] { method }, e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return col;
	}

	/**
	 * Business Method.
	 */
	public DataObject getDataObject(String qualifiedName)
		throws ServiceException {
		DataObject dobj = null;
		String method = "getDataObject(String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { qualifiedName },
			CAFPublicLogger.LEVEL_MEDIUM);
		try {
			dobj = mmr.getDataObject(qualifiedName);
		} catch (DataAccessException e) {
			location.throwing(method, e);
			throw new ServiceException("MMR_QUERY", new Object[] { method }, e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return dobj;
	}

	/**
	 * Business Method.
	 */
	public Collection getBusinessObjectNames() throws ServiceException {
		Collection colNames = new ArrayList();
		String method = "getBusinessObjectNames()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		try {
			colNames = mmr.getBusinessObjectNames();
		} catch (DataAccessException e) {
			location.throwing(method, e);
			throw new ServiceException("MMR_QUERY", new Object[] { method }, e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return colNames;
	}

	/**
	 * Business Method.
	 */
	public BusinessEntityInterface getBusinessEntityInterface(String qualifiedName)
		throws ServiceException {
		BusinessEntityInterface bei = null;
		String method = "getBusinessEntityInterface(String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { qualifiedName },
			CAFPublicLogger.LEVEL_MEDIUM);
		try {
			bei = mmr.getBusinessEntityInterface(qualifiedName);
		} catch (DataAccessException e) {
			location.throwing(method, e);
			throw new ServiceException("MMR_QUERY", new Object[] { method }, e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return bei;
	}

}
