/*
 * Created on 27.05.2004
 */
package com.sap.caf.rt.services.localization;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.srv.IDataContainerBean;

/**
 * @author pavel_henrykhsen
 */
public class LocalizationDataBean implements IDataContainerBean {

	public static final String PROP_OBJECTKEY = "objectKey";
	public static final String PROP_RES_NAME = "resourceName";
	public static final String PROP_ATTRIBUTE = "attribute";
	public static final String PROP_TEXT = "text";
	public static final String PROP_LANGUAGE = "language";
	public static final String PROP_CUSTOM_TYPE = "customType";

	private static List localizationPropInfo;
	
	static {
		localizationPropInfo = new ArrayList(6);
		localizationPropInfo.add(PROP_OBJECTKEY);
		localizationPropInfo.add(PROP_RES_NAME);
		localizationPropInfo.add(PROP_ATTRIBUTE);
		localizationPropInfo.add(PROP_TEXT);
		localizationPropInfo.add(PROP_LANGUAGE);
		localizationPropInfo.add(PROP_CUSTOM_TYPE);
	}
	
	private String objectKey; 
	private String resourceName; 
	private String attribute; 
	private String text; 
	private String language; 
	private String customType; 
	
	
	protected static class LocComparator implements Comparator {
		/* (non-Javadoc)
		 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
		 */
		public int compare(Object o1, Object o2) {
			String attr1 = ((LocalizationDataBean) o1).getAttribute();
			String attr2 = ((LocalizationDataBean) o2).getAttribute();
			if (attr1 != null) {
				return attr1.compareToIgnoreCase(attr2);
			} else {
				return (attr2 == null) ? 0 : 1;
			}
		}
	}

	public LocalizationDataBean() {
		super();
	}

	public LocalizationDataBean(LocalizationDataBean original) {
		this(original.objectKey, original.resourceName, original.text, original.language, original.customType);
	}
	
	public LocalizationDataBean(
			String objectKey, String resourceName, String text, String language, String customType) {
		this.objectKey = objectKey;
		this.resourceName = resourceName;
		this.text = text;
		this.language = language;
		this.customType = customType;
	}
	
	/* (non-Javadoc)
	 * @see com.sap.caf.rt.srv.IDataContainerBean#getProperty(java.lang.String)
	 */
	public Object getProperty(String propertyName) {
		Object prop = null;
		if (PROP_OBJECTKEY.equals(propertyName)) { prop = this.getObjectKey();}
			else if (PROP_RES_NAME.equals(propertyName)) { prop = this.getResourceName();}
			else if (PROP_ATTRIBUTE.equals(propertyName)) { prop = this.getAttribute(); }
			else if (PROP_TEXT.equals(propertyName)) { prop = this.getText();}
			else if (PROP_LANGUAGE.equals(propertyName)) { prop = this.getLanguage();}
			else if (PROP_CUSTOM_TYPE.equals(propertyName)) { prop = this.getCustomType();}
		return prop;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.srv.IDataContainerBean#setProperty(java.lang.String, java.lang.Object)
	 */
	public void setProperty(String propertyName, Object propertyValue) {
		if (PROP_OBJECTKEY.equals(propertyName)) { this.setObjectKey((String) propertyValue);}
			else if (PROP_RES_NAME.equals(propertyName)) { this.setResourceName((String) propertyValue);}
			else if (PROP_ATTRIBUTE.equals(propertyName)) { this.setAttribute((String) propertyValue);}
			else if (PROP_TEXT.equals(propertyName)) { this.setText((String) propertyValue);}
			else if (PROP_LANGUAGE.equals(propertyName)) { this.setLanguage((String) propertyValue);}
			else if (PROP_CUSTOM_TYPE.equals(propertyName)) { this.setCustomType((String) propertyValue);}
	}

	public String getObjectKey() {
		return objectKey;
	}

	public String getResourceName() {
		return resourceName;
	}

	public String getText() {
		return text;
	}

	public String getLanguage() {
		return language;
	}

	public String getCustomType() {
		return customType;
	}

	public void setObjectKey(String value) {
		objectKey = value;
	}

	public void setResourceName(String value) {
		resourceName = value;
	}

	public void setText(String value) {
		text = value;
	}

	public void setLanguage(String value) {
		language = value;
	}
	
	public void setCustomType(String value) {
		customType = value;
	}
	
	public String getAttribute() {
		if (attribute == null) {
			attribute = LocalizationResourceAccessor.getAttributeName(resourceName);
		}
		return attribute;
	}

	public void setAttribute(String attr) {
		attribute = attr;
	}
	
	public void validateData() throws ServiceException
	{
		if (text == null || "".equals(text)) {
			throw new ServiceException("LOCALIZATION_EMPTY_TEXT", 
					new String[] {getAttribute()});
		}
	}
	
	/* (non-Javadoc)
	 * @see com.sap.caf.rt.srv.IDataContainerBean#getPropertyList()
	 */
	public List getPropertyList() {
		return localizationPropInfo;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (super.equals(obj)) {
			return true;
		}
		if (obj instanceof LocalizationDataBean) {
			LocalizationDataBean bean = (LocalizationDataBean) obj;
			String key = getObjectKey();
			if (key != null) {
				return key.equals(bean.getObjectKey());
			}
		}
		return false;
	}

}
