package com.sap.caf.rt.services.config;

import java.util.Properties;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com
	.sap
	.engine
	.services
	.configuration
	.appconfiguration
	.ApplicationConfigHandlerFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
/**
 * @ejbHome <{none}>
 * @ejbLocal <{CAFContextLocal}>
 * @ejbLocalHome <{CAFContextLocalHome}>
 * @ejbRemote <{none}>
 * @stateless 
 */
public class CAFConfigBean implements SessionBean {
	private static final long serialVersionUID = 1;
	
	private static final String JARM_REQUEST = "CAF:RT:oal";
	private static final Location location =
		Location.getLocation(CAFConfigBean.class);

	public void ejbRemove() {
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setSessionContext(SessionContext context) {
		myContext = context;
		try {
			namingContext = new InitialContext();
		} catch (NamingException e) {
			if (location.beWarning())
							location.warningT("setSessionContext(SessionContext)", e.toString());
		}
	}

	private transient SessionContext myContext;
	private transient Context namingContext;
	/**
	 * Create Method.
	 */
	public void ejbCreate() throws CreateException {
		// TODO : Implement
	}

	public Properties getConfiguration() throws DataAccessException {
		String method = "getConfigHandler()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);

		Properties props = null;
		//String JNDI_NAME_JDO = null;
		try {
			Context ctx = new InitialContext();
			ApplicationConfigHandlerFactory chf =
				(ApplicationConfigHandlerFactory) ctx.lookup(
					"ApplicationConfiguration");
			props = chf.getApplicationProperties();

		} catch (NamingException e) {
			Object[] args = { "ApplicationConfiguration" };
			CAFPublicLogger.categoryCAF.logThrowableT(
				Severity.ERROR,
				location,
				method,
				"Error in JNDI lookup of {0}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return props;
	}

}
