package com.sap.caf.rt.metamodel;

import javax.resource.ResourceException;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

import com.sap.caf.metamodel.DataObject;

/**
 * @author d040882
 *
 * Opens the connection to the model repository. Only ONE connection is
 * used for all users who access the model repository via this interface.
 */
public class RepositoryConnection {
	private static IConnection con = null;
	private static final String APPLICATION = RepositoryConnection.class.getName();
	private static final String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
	private static final Location location =
		Location.getLocation(RepositoryConnection.class);

	public static synchronized IConnection getConnection() throws DataAccessException {
		if (con == null) {
			createConnection();
		}
		return con;
	}

	private static synchronized void createConnection()
		throws DataAccessException {
		String method = "createConnection()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);

		try {
			ConnectionSpec cxs = new ConnectionSpec();
			cxs.setReadOnly(true);
			cxs.setComponentClassLoader(DataObject.class.getClassLoader());

			ConnectionFactory mdrf = new ConnectionFactory();
			con = mdrf.getConnection(cxs);
		} catch (ResourceException ex) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error opening connection to model repository",
				ex);
			location.throwing(method, ex);
			throw new DataAccessException("MMR_CON_OPEN_ERROR", ex);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public static synchronized void closeConnection()
		throws DataAccessException {
		String method = "closeConnection()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		if (con != null) {
			try {
				con.close();
				con = null;
			} catch (ResourceException ex) {
				CAFPublicLogger.traceThrowableT(
					Severity.DEBUG,
					location,
					method,
					"Error closeing connection to model repository",
					ex);
				location.throwing(method, ex);
				throw new DataAccessException("MMR_CON_CLOSE_ERROR", ex);
			} finally {
				CAFPublicLogger.exiting(
					null,
					JARM_REQUEST,
					method,
					location,
					CAFPublicLogger.LEVEL_MEDIUM);
			}
		}
	}
}
