/*
 * Created on 2004-11-9
 */
package com.sap.caf.rt.exception;

import com.sap.caf.rt.util.CAFResourceAccessor;
import com.sap.exception.BaseRuntimeException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;

/**
 * @author I028584
 */
public class CAFBaseRuntimeException extends BaseRuntimeException {
	private static final long serialVersionUID = 1;

	public CAFBaseRuntimeException() {
		super();
	}

	public CAFBaseRuntimeException(Throwable cause) {
		super(cause);
	}
	protected CAFBaseRuntimeException(LocalizableText localizableText) {
		super(localizableText);
	}

	protected CAFBaseRuntimeException(
		LocalizableText localizableText,
		Throwable cause) {
		super(localizableText, cause);
	}

	public CAFBaseRuntimeException(LocalizableTextFormatter textFormatter) {
		super(textFormatter);
	}

	public CAFBaseRuntimeException(
		LocalizableTextFormatter textFormatter,
		Throwable cause) {
		super(textFormatter, cause);
	}

	
	public CAFBaseRuntimeException(String key) {
			super(
				new LocalizableTextFormatter(
					CAFResourceAccessor.getResourceAccessor(),
					key));
		}

	public CAFBaseRuntimeException(String key, Object[] args) {
		super(
			new LocalizableTextFormatter(
				CAFResourceAccessor.getResourceAccessor(),
				key,
				args));
	}

	public CAFBaseRuntimeException(String key, Object[] args, Throwable cause) {
		super(
			new LocalizableTextFormatter(
				CAFResourceAccessor.getResourceAccessor(),
				key,
				args),
			cause);
	}

}
