package com.sap.caf.rt.bol.util;

import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author d031666
 *
 * Provides static method to retrieve current user
 */
public class User {
	private static IUserFactory userFactory = UMFactory.getUserFactory();
	private static IUser user = null;
	private static final String APPLICATION = User.class.getName();
	private static String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
	private static final Location location = Location.getLocation(User.class);

	public static IUser getIUser(String userName) throws BEException {
		String method = "getIUser(String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { userName },
			CAFPublicLogger.LEVEL_MEDIUM);

		try {
			user = userFactory.getUser(userName);
		} catch (UMException ue) {
			String[] args = { userName };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error getting user {0} from userFactory",
				args,
				ue);
			location.throwing(method, ue);
			throw new BEException("BO_USER_NOT_FOUND", args, ue);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return user;
	}

}
