package com.sap.caf.rt.bol.util;

import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
/**
 * @author d025479
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class Subscriber {
	private static TopicConnection conn = null;
	private static Context context = null;
	private static String CF_NAME = "TopicConnectionFactory";
	private static String XAPPS_TOPIC = "jmsContext/xAppsBO";
	private static final String APPLICATION = Subscriber.class.getName();
	private static final String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;

	private TopicConnectionFactory cf = null;
	private TopicSession session;

	private static final Location location =
		Location.getLocation(Subscriber.class);

	private Subscriber() throws DataAccessException {
		String method = "Subscriber()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (conn == null) {
				cf = getTopicConnectionFactory();
				conn = cf.createTopicConnection();
			}
			// put conn start and stop into the publish method??
			conn.start();
		} catch (NamingException e) {
			Object[] args = { CF_NAME };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in creating TopicConnectionFactory {0}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} catch (JMSException e) {
			Object[] args = { CF_NAME };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in creating and starting TopicConnection to TopicConnectionFactory {0}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public static Subscriber getInstance() throws DataAccessException {
		String method = "getInstance()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		try {

			if (context == null) {
				context = new InitialContext();
			}
		} catch (NamingException e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in creating InitialContext",
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return new Subscriber();
	}

	protected TopicConnectionFactory getTopicConnectionFactory()
		throws NamingException {
		String method = "getTopicConnectionFactory()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);

		if (cf == null)
			cf = (TopicConnectionFactory) context.lookup(CF_NAME);
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		return cf;
	}

	protected Topic getTopic() throws NamingException {
		String method = "getTopic()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);

		Topic topic = null;
		topic = (Topic) context.lookup(XAPPS_TOPIC);
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		return topic;
	}

	public void getMessage() throws DataAccessException {
		String method = "getMessage()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);

		try {
			session = conn.createTopicSession(false, 0);
			TopicSubscriber topicSubscriber = null;

			try {
				topicSubscriber =
					session.createDurableSubscriber(getTopic(), "test");
			} catch (JMSException e) {
				Object[] args = { "test" };
				CAFPublicLogger.traceThrowableT(
					Severity.DEBUG,
					location,
					method,
					"JMSException in creating DurableSubscriber to topic {0} ",
					args,
					e);
				location.throwing(method, e);
				throw new DataAccessException(e);
			}
			// receive message

			try {
				TextMessage msg = (TextMessage) topicSubscriber.receive();
			} catch (JMSException e) {
				CAFPublicLogger.traceThrowableT(
					Severity.DEBUG,
					location,
					method,
					"JMSException in receiving message from Topic Subscribed",
					e);
				location.throwing(method, e);
				throw new DataAccessException(e);
			}

		} catch (JMSException e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"JMSException in creating Topic Session",
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} catch (NamingException e) {
			Object[] args = { "test" };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"NamingException in creating DurableSubscriber to topic {0}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			try {
				session.close();
				CAFPublicLogger.exiting(
					null,
					JARM_REQUEST,
					method,
					location,
					CAFPublicLogger.LEVEL_MEDIUM);
			} catch (JMSException e) {
				Object[] args = { session };
				CAFPublicLogger.traceThrowableT(
					Severity.DEBUG,
					location,
					method,
					"JMSException in session {0} close",
					args,
					e);
				location.throwing(method, e);
				CAFPublicLogger.exiting(
					null,
					JARM_REQUEST,
					method,
					location,
					CAFPublicLogger.LEVEL_MEDIUM);
				throw new DataAccessException(e);
			}
		}
	}

}
