package com.sap.caf.rt.bol.util;

import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;

/**
 * @author d025479
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class Publisher {
	//	TODO: Uncomment for jms usage in publishing process
	/*private static TopicConnection conn = null;
	private static Context context=null;
	private static String CF_NAME = CAFContext.JNDI_NAME_JMS;
	//private static String CF_NAME = "jmsfactory/TopicConnectionFactory";
	
	private static String XAPPS_TOPIC = CAFContext.JNDI_NAME_JMS_TOPIC;
	//private static String XAPPS_TOPIC = "jmstopics/default/sapDemoTopic";
	private TopicConnectionFactory cf = null;
	private TopicSession session;
	*/
	private static final String APPLICATION = Publisher.class.getName();
	private static String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
	public static String CHANGE = "BUSINESS_OBJECT_CHANGED";
	public static String REMOVE = "BUSINESS_OBJECT_REMOVED";
	public static String CREATE = "BUSINESS_OBJECT_CREATED";
	public static String[] msgTemplate =
		{ "OBJECT_TYPE", "KEY", "RID", "USEDBY" };
	private String msgText = "";
	private static final Location location =
		Location.getLocation(Publisher.class);

	private Publisher() throws DataAccessException {
		String method = "Publisher()";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);

		//TODO: Uncomment for jms usage in publishing process
		/*		try {
					if (conn == null) {
						
						//CAFContext.getMonitor(null, "MyRequest").startComponent("JMS:createTopicConnection");
						
						cf = getTopicConnectionFactory();
						conn = cf.createTopicConnection();
						//conn = cf.createTopicConnection(CAFContext.JNDI_USER,CAFContext.JNDI_PWD);
						
						//CAFContext.getMonitor(null, "MyRequest").endComponent("JMS:createTopicConnection");
						//CAFContext.getMonitor(null, "MyRequest").endRequest("MyRequest");
					
					}
					// put conn start and stop into the publish method??
					conn.start(); 
				} catch (NamingException e) {
					Object[] args = { CF_NAME, e.getMessage()};
					BOPublicLogger.SYS_SERVER.errorT(
						BOPublicLogger.LOC_CAF, "JMS_NAMING", args);
					BOPublicLogger.traceThrowable(
						Severity.ERROR, BOPublicLogger.LOC_CAF, "Publisher()", e);
					BOPublicLogger.LOC_CAF.throwing("Publisher()", e);
					BOPublicLogger.exiting(null, JARM_REQUEST, method, BOPublicLogger.LOC_CAF);
					//throw new DataAccessException(e);
				} catch (JMSException e) {
					Object[] args = { CF_NAME, e.getMessage()};
					BOPublicLogger.SYS_SERVER.errorT(
						BOPublicLogger.LOC_CAF, "JMS_CONNECTION", args);
					BOPublicLogger.traceThrowable(
						Severity.ERROR, BOPublicLogger.LOC_CAF, "Publisher()", e);
					BOPublicLogger.LOC_CAF.throwing("Publisher()", e);
					BOPublicLogger.exiting(null, JARM_REQUEST, method, BOPublicLogger.LOC_CAF);
					//throw new DataAccessException(e);
				} */
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
	}

	public static Publisher getInstance() throws DataAccessException {
		String method = "getInstance()";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);

		//		TODO: Uncomment for jms usage in publishing process
		/*if (context==null){
			
			//CAFContext.getMonitor(null, "MyRequest").startComponent("JMS:initialContext");
			
			context = new InitialContext();
			
			//CAFContext.getMonitor(null, "MyRequest").endComponent("JMS:initialContext");
			//CAFContext.getMonitor(null, "MyRequest").endRequest("MyRequest");
		}*/

		//context = new InitialContext();}
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		return new Publisher();
	}
	//	TODO: Uncomment for jms usage in publishing process

	/*protected TopicConnectionFactory getTopicConnectionFactory()
					throws NamingException {
			String method = "getTopicConnetionFactory()";
			BOPublicLogger.entering(null, JARM_REQUEST, method, BOPublicLogger.LOC_CAF);
			if (cf == null) {
				
				//CAFContext.getMonitor(null, "MyRequest").startComponent("JMS:lookupTopicConnectionFactory");
				
				cf = (TopicConnectionFactory) context.lookup(CF_NAME);
				
				//CAFContext.getMonitor(null, "MyRequest").endComponent("JMS:lookupTopicConnectionFactory");
				//CAFContext.getMonitor(null, "MyRequest").endRequest("MyRequest");
				
			}
			BOPublicLogger.exiting(null, JARM_REQUEST, method, BOPublicLogger.LOC_CAF);
			return cf;
		}
	
		protected Topic getTopic() throws NamingException{
			String method = "getTopic";
			BOPublicLogger.entering(null, JARM_REQUEST, method, BOPublicLogger.LOC_CAF);
			Topic topic= null;
			
			//CAFContext.getMonitor(null, "MyRequest").startComponent("JMS:lookupTopic");
			
			topic = (Topic) context.lookup(XAPPS_TOPIC);
			
			//CAFContext.getMonitor(null, "MyRequest").endComponent("JMS:lookupTopic");
			//CAFContext.getMonitor(null, "MyRequest").endRequest("MyRequest");
			
			BOPublicLogger.exiting(null, JARM_REQUEST, method, BOPublicLogger.LOC_CAF);
			return topic;
		}*/

	public void publishChanged(Object[] args) throws BEException {
		String method = "publishChanged(Object[])";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);

		try {
			for (int i = 0; i < args.length; i++) {
				if (i != 0)
					msgText = msgText + "%$%";
				msgText = msgText + msgTemplate[i] + " " + args[i];
			}
			publish(args[0].toString(), CHANGE, msgText);
		} catch (IndexOutOfBoundsException e) {
			throw new BEException("CAF_INVALID_INPUT", null, e);
		} catch (DataAccessException e) {
			location.throwing(method, e);
			throw new BEException(
				"CAF_PUBLISH_ERROR",
				new Object[] { msgText },
				e);
		} finally {
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void publishRemoved(Object[] args) throws BEException {
		String method = "publishRemoved(Object[])";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			for (int i = 0; i < args.length; i++) {
				if (i != 0)
					msgText = msgText + "%$%";
				msgText = msgText + msgTemplate[i] + " " + args[i];
			}
			publish(args[0].toString(), REMOVE, msgText);
		} catch (IndexOutOfBoundsException e) {
			throw new BEException("CAF_INVALID_INPUT", null, e);
		} catch (DataAccessException e) {
			location.throwing(method, e);
			throw new BEException(
				"CAF_PUBLISH_ERROR",
				new Object[] { msgText },
				e);
		} finally {
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void publishCreated(Object[] args) throws BEException {
		String method = "publishCreated(Object[])";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			for (int i = 0; i < args.length; i++) {
				if (i != 0)
					msgText = msgText + "%$%";
				msgText = msgText + msgTemplate[i] + " " + args[i];
			}
			publish(args[0].toString(), CREATE, msgText);
		} catch (IndexOutOfBoundsException e) {
			throw new BEException("CAF_INVALID_INPUT", null, e);
		} catch (DataAccessException e) {
			location.throwing(method, e);
			throw new BEException(
				"CAF_PUBLISH_ERROR",
				new Object[] { msgText },
				e);
		} finally {
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	private synchronized void publish(
		String objType,
		String action,
		String msgText)
		throws DataAccessException {
		String method = "publish(String, String, String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { objType, action, msgText }, CAFPublicLogger.LEVEL_MEDIUM);

		//		TODO: Uncomment for jms usage in publishing process
		/*		try {
					if(conn==null)
						return;
						
					//CAFContext.getMonitor(null, "MyRequest").startComponent("JMS:createTopicSession");
					
					session = conn.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
					
					//CAFContext.getMonitor(null, "MyRequest").endComponent("JMS:createTopicSession");
					
					TextMessage msg = session.createTextMessage(msgText);
					msg.setStringProperty("ACTION", action);
					msg.setStringProperty("OBJECT_TYPE", objType);
					msg.setText(msgText);
					Topic topic = getTopic();
					
					//CAFContext.getMonitor(null, "MyRequest").startComponent("JMS:createPublisher");
					
					TopicPublisher pub = session.createPublisher(topic);
					
					//CAFContext.getMonitor(null, "MyRequest").endComponent("JMS:createPublisher");
					//CAFContext.getMonitor(null, "MyRequest").startComponent("JMS:publish");
					
					pub.publish(msg);
					
					//CAFContext.getMonitor(null, "MyRequest").endComponent("JMS:publish");
				} catch (JMSException e) {
					Object[] args = { CF_NAME, e.getMessage()};
					BOPublicLogger.SYS_SERVER.errorT(
						BOPublicLogger.LOC_CAF, "JMS_CONNECTION", args);
					BOPublicLogger.traceThrowable(
						Severity.ERROR, BOPublicLogger.LOC_CAF,
						"publish(String, String, String)", e);
					BOPublicLogger.LOC_CAF.throwing(
						"publish(String, String, String)", e);
					BOPublicLogger.exiting(null, JARM_REQUEST, method, BOPublicLogger.LOC_CAF);
					throw new DataAccessException(e);
				} catch (NamingException e) {
					Object[] args = { CF_NAME, e.getMessage()};
					BOPublicLogger.SYS_SERVER.errorT(
						BOPublicLogger.LOC_CAF, "JMS_NAMING", args);
					BOPublicLogger.traceThrowable(
						Severity.ERROR, BOPublicLogger.LOC_CAF,
						"publish(String, String, String)", e);
					BOPublicLogger.LOC_CAF.throwing(
						"publish(String, String, String)", e);
					BOPublicLogger.exiting(null, JARM_REQUEST, method, BOPublicLogger.LOC_CAF);
					throw new DataAccessException(e);
				} finally {
					if (session != null)
						try {
							
							//CAFContext.getMonitor(null, "MyRequest").startComponent("JMS:closeSession");
							
							session.close();
							
							//CAFContext.getMonitor(null, "MyRequest").endComponent("JMS:closeSession");
							//CAFContext.getMonitor(null, "MyRequest").endRequest("MyRequest");
							
						} catch (JMSException e) {
							Object[] args = { CF_NAME, e.getMessage()};
							BOPublicLogger.SYS_SERVER.errorT(
								BOPublicLogger.LOC_CAF, "JMS_CONNECTION", args);
							BOPublicLogger.traceThrowable(
								Severity.ERROR, BOPublicLogger.LOC_CAF,
								"publish(String, String, String)", e);
							BOPublicLogger.LOC_CAF.throwing(
								"publish(String, String, String)", e);
							throw new DataAccessException(e);
				}
			}*/
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
	}
}
