package com.sap.caf.rt.bol.util;

import java.util.LinkedList;
import java.util.List;

import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;

/**
 * @author d025479
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class BOInfo {
	public static String JNDI_PREFIX = "localejbs";
	public static LinkedList xApps = null;
	private static final Location location = Location.getLocation(BOInfo.class);
	private static final String APPLICATION = BOInfo.class.getName();
	private static String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;

	public BOInfo() {
	}

	/**
	 * This method returns a list of all xApps installed in the meta data
	 * repository.
	 */
	public static List getApplications() {
		String method = "getApplications()";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);

		if (xApps == null) {
			xApps = new LinkedList();
			// get xApps from MMR
			xApps.add("sap.com/xapps/testoal");
		}
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		return xApps;
	}

	/**
	 * This method returns a list of all business objects belonging to
	 * the selected xApp.
	 */
	public List getBusinessObjects(String application) {
		String method = "getBusinessObjects(String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { application }, CAFPublicLogger.LEVEL_MEDIUM);

		LinkedList objects = new LinkedList();
		// read list of business objects for given application from MMR
		objects.add("sap.com/xapps/testoal/Project");
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		return objects;
	}

	/**
	 * This method provides the JNDI name of the local entity bean
	 * assigned to the business object.
	 */
	public static String getJNDIName(String applicationName, String boName) {
		String method = "getJNDIName(String, String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { applicationName, boName }, CAFPublicLogger.LEVEL_MEDIUM);
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		return JNDI_PREFIX + "/" + boName;
	}

}
