package com.sap.caf.rt.bol.pk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.guid.GUIDGeneratorFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author d025479
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class PrimaryKeyFactory {

	private static String NUMBER = "NUMBER";
	private static String STRING = "STRING";
	private static final String APPLICATION = PrimaryKeyFactory.class.getName();
	private static String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
	private static PrimaryKeyFactory primKeyFactory = null;
	private PersistenceManager pm = null;
	private PersistenceManagerFactory pmf = null;
	public static final String JNDI_NAME = CAFContext.JNDI_NAME_JDO;
	private static final Location location =
		Location.getLocation(PrimaryKeyFactory.class);

	private PrimaryKeyFactory() throws DataAccessException {
		String method = "PrimaryKeyFactory()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		try {
			Context ctx = new InitialContext();
			//ds = (DataSource)ctx.lookup("jdbc/SAPC20DB");
			pmf = (PersistenceManagerFactory) ctx.lookup(JNDI_NAME);
		} catch (NamingException e) {
			Object[] args = { JNDI_NAME };
			CAFPublicLogger.categoryCAF.logThrowableT(
				Severity.ERROR,
				location,
				method,
				"Error in JNDI lookup of {0}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}
	/** This getInstance method provides singleton access to the
	*   PrimaryKeyFactory.
	*/
	public static synchronized PrimaryKeyFactory getInstance()
		throws DataAccessException {
		String method = "getInstance()";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		if (primKeyFactory == null)
			primKeyFactory = new PrimaryKeyFactory();
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		return primKeyFactory;
	}

	/** This method returns a GUID as technical primary key of the Business Object,
	 *  This key is used as identity of the persistent object
	 *  (primary key of the database tables and of the JDO instance) and as logical
	 *  foreign key in relations between business objects and dependent objects
	*/
	public String getPrimaryKey() {
		String method = "getPrimaryKey";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);

		// call GUID service
		String guid =
			GUIDGeneratorFactory
				.getInstance()
				.createGUIDGenerator()
				.createGUID()
				.toString();
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		return guid;
	}

	public String getBusinessObjectId(
		String objectName,
		String objectGroup,
		String format)
		throws DataAccessException {
		String method = "getBusinessObjectId(String, String, String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { objectName, objectGroup, format },
			CAFPublicLogger.LEVEL_MEDIUM);
		if ((format.toUpperCase() != NUMBER)
			&& (format.toUpperCase() != STRING)) {
			throw new DataAccessException("BO_INVALID_TYPE");
		}
		String key = null;
		Collection resultSet = null;
		Class objectClass = com.sap.caf.rt.bol.pk.NumberRangeEntry.class;
		String filter = "key == objectName && objGroup == objectGroup";
		try {
			pm = pmf.getPersistenceManager();
			Extent ext = pm.getExtent(objectClass, true);
			Query query = null;
			query = pm.newQuery(ext, filter);
			query.declareParameters("String objectName, String objectGroup");
			resultSet = (Collection) query.execute(objectName, objectGroup);
			pm.close();
			Iterator iter = resultSet.iterator();
			int i = 1;
			String max = null;
			NumberRangeEntry numRangeEntry = null;
			int indx = 0;
			while (iter.hasNext()) {
				numRangeEntry =
					(com.sap.caf.rt.bol.pk.NumberRangeEntry) iter.next();
				indx = numRangeEntry.getIndex();
				key = numRangeEntry.getActCounter();
				max = numRangeEntry.getHigh();
				//can active value not be out of range?
				if (format.toUpperCase() == NUMBER) {
					if ((Integer.parseInt(key.trim()) + 1
						< Integer.parseInt(max.trim()))
						&& (Integer.parseInt(key.trim())
							> Integer.parseInt(numRangeEntry.getLow().trim())))
						break;
				} else {
					if ((key.compareTo(max.trim()) < 0)
						&& (key.compareTo(numRangeEntry.getLow().trim()) > 0))
						break;
				}
			}
			// increase the counter by 1
			String newCounter;
			newCounter = Incrementor.increment(key, max, format);
			numRangeEntry.setActCounter(newCounter);
		} catch (javax.jdo.JDOUserException e) {
			Object[] args = { objectName, objectGroup, format };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in getBusinessObjectId of objectName : {0} objectGroup : {1} format : {2}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} catch (Exception e) {
			Object[] args = { objectName, objectGroup, format };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in getBusinessObjectId of objectName : {0} objectGroup : {1} format : {2}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return key;
	}

	/**
	 *  This method creates a new number range for the business object and
	 *  subgroup.
	 *
	 */
	public void setNumberRange(
		String objectName,
		String objectGroup,
		String low,
		String high,
		boolean ext)
		throws DataAccessException {
		String method =  "setNumberRange(String, String, String, String, boolean)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { objectName, objectGroup, low, high, ext + "" },
			CAFPublicLogger.LEVEL_MEDIUM);
		String key = null;
		Collection resultSet = null;
		Class objectClass = com.sap.caf.rt.bol.pk.NumberRangeEntry.class;
		String filter = "key == objectName && objGroup == objectGroup";
		try {
			pm = pmf.getPersistenceManager();
			Extent extent = pm.getExtent(objectClass, true);
			Query query = null;
			query = pm.newQuery(extent, filter);
			query.declareParameters("String objectName, String objectGroup");
			resultSet = (Collection) query.execute(objectName, objectGroup);

			// look if a number range already exists for the business object
			Iterator iter = resultSet.iterator();
			int i = 1;
			String max = null;
			NumberRangeEntry numRangeEntry = null;
			NumberRangeEntry numRangeEntryLast = null;

			int indx = 0;
			//int indxActive = 0;
			while (iter.hasNext()) {
				numRangeEntryLast = (NumberRangeEntry) iter.next();
				indx = numRangeEntryLast.getIndex();
				key = numRangeEntryLast.getActCounter();
				max = numRangeEntryLast.getHigh();
			}
			//if(indx == 0) ++indx;
			++indx;
			//change to diff instance variable
			numRangeEntry = new NumberRangeEntry(objectName, objectGroup, indx);
			numRangeEntry.setObjectGroup(objectGroup);
			numRangeEntry.setIndex(indx);
			numRangeEntry.setActCounter(low);
			numRangeEntry.setExternal(ext);
			numRangeEntry.setHigh(high);
			numRangeEntry.setLow(low);
			pm.makePersistent(numRangeEntry);
		} catch (javax.jdo.JDOUserException e) {
			Object[] args = { objectName, objectGroup, low, high, ext + "" };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"JDOUserException in getBusinessObjectId of objectName : {0} objectGroup : {1} low value : {2} high value : {3} external : {4}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} catch (Exception e) {
			Object[] args = { objectName, objectGroup, low, high, ext + "" };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in getBusinessObjectId of objectName : {0} objectGroup : {1} low value : {2} high value : {3} external : {4}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
			pm.close();
		}
	}

	public Collection getNumberRange(String objectName, String objectGroup)
		throws DataAccessException {
		String method = "getNumberRange(String, String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { objectName, objectGroup },
			CAFPublicLogger.LEVEL_MEDIUM);
		String key = null;
		Collection resultSet = null;
		List numRangeEntryList = new ArrayList(10); //change
		Class objectClass = com.sap.caf.rt.bol.pk.NumberRangeEntry.class;
		String filter = "key == objectName && objGroup == objectGroup";

		try {
			pm = pmf.getPersistenceManager();
			Extent extent = pm.getExtent(objectClass, true);
			Query query = null;
			query = pm.newQuery(extent, filter);
			query.declareParameters("String objectName, String objectGroup");
			resultSet = (Collection) query.execute(objectName, objectGroup);
			Iterator iter = resultSet.iterator();

			String max = null;
			NumberRangeEntry numRangeEntry = null;

			int indx = 0;
			int i = 0;
			int[] indxArray = new int[10];

			while (iter.hasNext()) {
				numRangeEntry = (NumberRangeEntry) iter.next();
				indx = numRangeEntry.getIndex();
				indxArray[i] = indx;
				++i;
				key = numRangeEntry.getActCounter();
				max = numRangeEntry.getHigh();
				numRangeEntryList.add(numRangeEntry);
			}
			//@todo check if more nre possible in lower index and return acutal row
		} catch (Exception e) {
			Object[] args = { objectName, objectGroup };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in getNumberRange of objectName : {0} objectGroup : {1} ",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
			pm.close();
		}

		return numRangeEntryList;
	}
}
