package com.sap.caf.rt.bol.pk;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class Incrementor {
	private static final String APPLICATION = Incrementor.class.getName();
	private static String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
	private static final Location location =
		Location.getLocation(Incrementor.class);

	/** This method increments an alpha-numeric string by 1.
	 *  Increment of 1 means the next element out of the series (0-10,A-Z)
	 *  If the length exceeds the maximal length of the string a
	 *  NumberOutOfRangeException is thrown.
	 *  Only uppercases are supported.
	 */
	public static String increment(String value, String maxValue, String type)
		throws DataAccessException {
		String method = "increment(String, String, String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { value, maxValue, type },
			CAFPublicLogger.LEVEL_MEDIUM);

		String key = null;

		if (type.toUpperCase() == "NUMBER")
			key = incrementNumber(value, maxValue);
		else {
			if (type.toUpperCase() == "CHAR")
				key = incrementString(value, maxValue);
			else {
				throw new DataAccessException("BO_INVALID_TYPE");
			}
		}
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		return key;
	}
	public static String incrementString(String value, String maxValue)
		throws DataAccessException {
		String method = "incrementString(String, String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { value, maxValue },
			CAFPublicLogger.LEVEL_MEDIUM);

		char lastChar = value.charAt(value.length() - 1);

		// convert last character of input string to its numeric expression
		int lastDigit = Character.digit(lastChar, Character.MAX_RADIX);
		// increase character by 1. If last character is reached, add new character to string
		if (lastDigit < Character.MAX_RADIX - 1) {
			char newChar =
				Character.forDigit(lastDigit + 1, Character.MAX_RADIX);
			value = value.substring(0, value.length() - 1) + newChar;
		} else {
			char newChar =
				Character.forDigit(
					Character.MIN_RADIX - 1,
					Character.MAX_RADIX);
			value = value + newChar;
		}
		if (isGreater(value, maxValue))
			throw new DataAccessException(
				"BO_OUT_OF_RANGE",
				new Object[] { value, maxValue });

		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		return value.toUpperCase();
	}
	public static String incrementNumber(String value, String maxValue)
		throws DataAccessException {
		String method = "incrementNumber(String, String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { value, maxValue },
			CAFPublicLogger.LEVEL_MEDIUM);

		long key = Long.parseLong(value.trim());
		if (key == Long.parseLong(maxValue.trim()))
			throw new DataAccessException(
				"BO_OUT_OF_RANGE",
				new Object[] { value, maxValue });
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		return String.valueOf(key + 1);
	}
	public static boolean isGreater(String value, String maxValue) {
		boolean gt = true;
		if (value.length() <= maxValue.length()) {
			if (value.toUpperCase().compareTo(maxValue.toUpperCase()) <= 0)
				gt = false;
		}
		return gt;
	}
}
