package com.sap.caf.rt.bol.pk;

/**
 * The primary key of a Business Object is always a GUID. This template
 * is extended by the primary key class because there must be a different
 * primary key class for every Business Object.
 */
public abstract class AbstractPrimaryKey implements java.io.Serializable {
	private static final long serialVersionUID = 1;

	public String key;
	public AbstractPrimaryKey() {
	}
	public AbstractPrimaryKey(String guid) {
		key = guid;
	}

	public boolean equals(Object o) {
		if (o == null || !getClass().equals(o.getClass()))
			return false;
		if (key == null) {
			if (o == null)
				return true;
			else
				return false;
		}
		if (o == null)
			return false;
		AbstractPrimaryKey other = (AbstractPrimaryKey) o;
		return key.equals(other.key);
	}

	public int hashCode() {
		if (key == null)
			return 0;
		return key.hashCode();
	}

	public String toString() {
		if (key == null)
			return null;
		return key.toString();
	}
}
