 /*
 * Created on Mar 15, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.rt.bol.da.remote;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

import javax.naming.InitialContext;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.ExternalException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp_mmr_bridge.MpMmrBridgeFactory;
import com.sap.caf.mp_mmr_bridge.rt.IExternalOperationConfig;
import com.sap.caf.mp_mmr_bridge.rt.IOperationPattern;
import com.sap.caf.mp_mmr_bridge.rt.IRuntimeHelper;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.da.IDataAccessService;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.da.DataAccessFactory;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.bol.util.IntQueryFilter;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.bol.util.UserContext;
import com.sap.caf.rt.context.RTContextLocal;
import com.sap.caf.rt.context.RTContextLocalHome;
import com.sap.dictionary.runtime.DdDictionaryPool;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.IBroker;
import com.sap.dictionary.runtime.IDataType;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author trendafil-m
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class RemoteDataAccessService implements IDataAccessService {
	private static final long serialVersionUID = 1;
	
	private static RemoteDataAccessService service;	
	private static ICoreFactory coreFactory;
	private static IDataServiceFactory dataServiceFactory;
	private IDataAccessService jdoDataAccessService;
	private transient IRuntimeHelper runtimeHelper;
	private UserContext userContext = null;	

	private static final String JARM_REQUEST = "CAF:RT:oal";
	private static final Location location =
		Location.getLocation(RemoteDataAccessService.class);

	private static final String MAPPINGS_DELIMETER = "/";
	
	private static ArrayList parseObjectType(IDependentObject object)
	{
		ArrayList retVal = new ArrayList();
		
		String objectType = object.getObjectType();
		int firstSlash = objectType.indexOf('/');
		int secondSlash = objectType.indexOf('/', firstSlash + 1);
		
		String provider, application, name;
		if (firstSlash >= 0  &&  secondSlash >= 0)
		{
			provider = objectType.substring(0, firstSlash);
			application = objectType.substring(firstSlash + 1, secondSlash);
			name = objectType.substring(secondSlash + 1);
		}
		else
		{
			provider = null;
			application = null;
			name = objectType;
		}
		
		retVal.add(provider);
		retVal.add(application);
		retVal.add(name);
		
		return retVal;
	}

	private RemoteDataAccessService() throws DataAccessException {
		try {
			InitialContext context = new InitialContext();
			coreFactory =
				(ICoreFactory) context.lookup(ICoreFactory.JNDI_REGISTRY_NAME);
			dataServiceFactory = coreFactory.getDataServiceFactory();
			jdoDataAccessService =
				DataAccessFactory.getDataAccessService(
					DataAccessFactory.DATASOURCE_LOCAL);
			runtimeHelper = MpMmrBridgeFactory.getRuntimeHelper();
		} catch (Exception e) {
			throw new DataAccessException(e);
		}
	}

	public static RemoteDataAccessService getInstance()
		throws DataAccessException {
		String method = "getInstance()";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location);
		if (service == null)
			service = new RemoteDataAccessService();
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { service });
		return service;
	}

	public void setUserContext(UserContext userCtx) 
	{
		this.userContext = userCtx;
	}

	public IBusinessObject executeOperation(
		IBusinessObject input,
		IMessage sourceMessage,
		String serviceId,
		String operationName,
		String mappingRuleIdIn,
		String mappingRuleIdOut)
		throws EngineException, InvocationException, ExternalException {
		String method =
			"executeOperation(IBusinessObject, IMessage, String, String, String, String)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] {
				input,
				sourceMessage,
				serviceId,
				operationName,
				mappingRuleIdIn,
				mappingRuleIdOut });
		MessageEntityConverter msgEntityConverter = MessageEntityConverter.getInstance(); 
				
		IMessageValue inputMessageValue =
			msgEntityConverter.createInputMessageValue(input, sourceMessage);

		IUserAccount callerAccount = getCallerAccount();
		IMessageValue responseMessageValue =
			dataServiceFactory.executeOperation(
				inputMessageValue,
				mappingRuleIdIn,
				serviceId,
				operationName,
				mappingRuleIdOut, 
				callerAccount);

		IBusinessObject result = null;
		if (mappingRuleIdOut != null  &&  responseMessageValue != null) {
		   result = msgEntityConverter.createOutputBusinessObject(responseMessageValue, input.getClass());
		}   
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { result });
		return result;
	}

	private Object retrieveElementValue(
		IElementValue elementValue,
		Object object,
		String source, boolean bypassOneLevel)
		throws InvocationException {
		location.debugT("Entering retrieveElementValue()");
		String elementValueName = elementValue.getElement().getName();
		location.debugT("Processing element with name=" + elementValueName);
		Object result = object;
		Enumeration typeValues = elementValue.getTypeValueEnumeration();
		while (typeValues.hasMoreElements()) {
			ITypeValue typeValue = (ITypeValue) typeValues.nextElement();
			if (typeValue instanceof IComplexTypeValue) {
				location.debugT("Element type is complex type");
				IComplexTypeValue complexTypeValue =
					(IComplexTypeValue) typeValue;
				result =
					retrieveComplexTypeValue(
						complexTypeValue,
						result,
						source + MAPPINGS_DELIMETER + elementValueName, bypassOneLevel);
			} else if (typeValue instanceof ISimpleTypeValue) {
				location.debugT("Element type is simple type");
				ISimpleTypeValue simpleTypeValue = (ISimpleTypeValue) typeValue;
				result =
					retrieveSimpleTypeValue(
						simpleTypeValue,
						result,
						source + MAPPINGS_DELIMETER + elementValueName, bypassOneLevel);
			}
		}
		location.debugT("Exiting retrieveElementValue()");
		return result;
	}

	private Object retrieveComplexTypeValue(
		IComplexTypeValue complexTypeValue,
		Object object,
		String source, boolean bypassOneLevel)
		throws InvocationException {
		location.debugT("Entering retrieveComplexTypeValue()");
		Object result = object;
		Enumeration elementValues =
			complexTypeValue.getElementValueEnumeration();
		while (elementValues.hasMoreElements()) {
			IElementValue elementValue =
				(IElementValue) elementValues.nextElement();
			result = retrieveElementValue(elementValue, result, source, bypassOneLevel);
		}
		location.debugT("Exiting retrieveComplexTypeValue()");
		return result;
	}

	private Object retrieveSimpleTypeValue(
		ISimpleTypeValue simpleTypeValue,
		Object object,
		String source, boolean bypassOneLevel)
		throws InvocationException {
		location.debugT("Entering retrieveSimpleTypeValue()");
		Object result = object;
		location.debugT("source=" + source);
		if ((source != null) && (!source.equals(""))) {
			// bypass 2 levels - parameters/OperationName
			source = source.substring(source.indexOf("/")+1);			
			source = source.substring(source.indexOf("/")+1);
			// bypass one more level if query operation
			if (bypassOneLevel) {
				source = source.substring(source.indexOf("/")+1);							
			}
			result = setValue(result, source, simpleTypeValue);
		}
		location.debugT("Exiting retrieveSimpleTypeValue()");
		return result;
	}

	private Object setValue(
		Object object,
		String source,
		ISimpleTypeValue value)
		throws InvocationException {
		location.debugT("Entering setValue()");
		Object result = object;
		StringTokenizer tokenizer =
			new StringTokenizer(source, MAPPINGS_DELIMETER);
		Object current = result;
		while (tokenizer.hasMoreTokens()) {
			String token = tokenizer.nextToken();
			if (!tokenizer.hasMoreTokens()) {
				// last token								
				Class objectClass = null;
				Object objectValue = null;
				int base = value.getSimpleType().getBase();
				location.debugT("Base type number=" + base);
				switch (base) {
					case ISimpleType.BASE_BASE64BINARY :
						location.debugT("Base type is base64binary");
						objectClass = byte[].class;
						objectValue = value.getValueByteArray();
						break;
					case ISimpleType.BASE_BOOLEAN :
						location.debugT("Base type is boolean");
                        objectClass = boolean.class;
                        objectValue = value.getValueBoolean();						
						
						break;
					case ISimpleType.BASE_BYTE :
						location.debugT("Base type is byte");
						objectClass = byte.class;
						objectValue = new Byte((value.getValue()));
						break;
					case ISimpleType.BASE_DATE :
						location.debugT("Base type is date");
						objectClass = Date.class;
						objectValue = value.getValueDate();
						break;
					case ISimpleType.BASE_DECIMAL :
						location.debugT("Base type is decimal");
						objectClass = BigDecimal.class;
						objectValue = value.getValueBigDecimal();
						break;
					case ISimpleType.BASE_DOUBLE :
						location.debugT("Base type is double");
						objectClass = double.class;
						objectValue = value.getValueDouble();
						break;
					case ISimpleType.BASE_FLOAT :
						location.debugT("Base type is float");
						objectClass = float.class;
						objectValue = new Float(value.getValue());
						break;
					case ISimpleType.BASE_INT :
						location.debugT("Base type is int");
						objectClass = int.class;
						objectValue = value.getValueInteger();
						break;
					case ISimpleType.BASE_INTEGER :
						location.debugT("Base type is integer");
						objectClass = Integer.class;
						objectValue = value.getValueInteger();
						break;
					case ISimpleType.BASE_LONG :
						location.debugT("Base type is long");
						objectClass = long.class;
						objectValue = new Long(value.getValue());
						break;
					case ISimpleType.BASE_SHORT :
						location.debugT("Base type is short");
						objectClass = short.class;
						objectValue = new Short(value.getValue());
						break;
					case ISimpleType.BASE_STRING :
						location.debugT("Base type is string");
						objectClass = String.class;
						objectValue = value.getValueString();
						break;
					case ISimpleType.BASE_TIME :
						location.debugT("Base type is time");
						objectClass = Date.class;
						objectValue = value.getValueDate();
						break;
					case ISimpleType.BASE_TIMESTAMP :
						location.debugT("Base type is timestamp");
						objectClass = Date.class;
						objectValue = value.getValueDate();
						break;
					case ISimpleType.BASE_UNSIGNED_BYTE :
						location.debugT("Base type is unsigned byte");
						objectClass = byte.class;
						objectValue = new Byte(value.getValue());
						if (((Byte) objectValue).byteValue() < 0)
							throw new InvocationException("Base type is unsigned but value is negative.");
						break;
					case ISimpleType.BASE_UNSIGNED_INT :
						location.debugT("Base type is unsigned int");
						objectClass = int.class;
						objectValue = value.getValueInteger();
						if (((Integer) objectValue).intValue() < 0)
							throw new InvocationException("Base type is unsigned but value is negative.");
						break;
					case ISimpleType.BASE_UNSIGNED_LONG :
						location.debugT("Base type is unsigned long");
						objectClass = long.class;
						objectValue = new Long(value.getValue());
						if (((Long) objectValue).longValue() < 0)
							throw new InvocationException("Base type is unsigned but value is negative.");
						break;
					case ISimpleType.BASE_UNSIGNED_SHORT :
						location.debugT("Base type is unsigned short");
						objectClass = short.class;
						objectValue = new Short(value.getValue());
						if (((Short) objectValue).shortValue() < 0)
							throw new InvocationException("Base type is unsigned but value is negative.");
						break;
					default :
						throw new InvocationException("Unknown simple type.");
				}
				location.debugT("value=" + objectValue);
				try {
					if (current instanceof IDependentObject)
					{
						((IDependentObject)current).setProperty(token, objectValue);
					}
					else
					{
						Method method =
							current.getClass().getMethod(
								"set"
									+ token.substring(0, 1).toUpperCase()
									+ token.substring(1),
								new Class[] { objectClass });
						method.invoke(current, new Object[] { objectValue });
					}
				} catch (Exception e) {
					throw new InvocationException(e);
				}
				break;
			}
			try {
				if (current instanceof IDependentObject)
				{
					current = ((IDependentObject)current).getProperty(token);
				}
				else
				{
					Method method =
						current.getClass().getMethod(
							"get"
								+ token.substring(0, 1).toUpperCase()
								+ token.substring(1),
							new Class[0]);
					current = method.invoke(current, new Object[0]);
				}
			} catch (Exception e) {
				throw new InvocationException(e);
			}
		}
		location.debugT("Exiting setValue()");
		return result;
	}

	public void activate() {
	}

	public String create(IDependentObject object) throws DataAccessException {
		IBusinessObject result;
		String method = "create(IDependentObject)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { object });
		try {
			ArrayList beCoordinates = RemoteDataAccessService.parseObjectType(object);
			String provider = (String)beCoordinates.get(0);
			String application = (String)beCoordinates.get(1);
			String beName = (String)beCoordinates.get(2);
			BusinessEntityInterface be = (new MetaModel()).getBusinessEntityInterface(provider, application, beName + "Service"); 
			
			List keys =	be.getBusinessEntity().getKeys();			
			IExternalOperationConfig config =
				runtimeHelper.getExternalOperationConfig(
					be,
					IOperationPattern.CREATE);
			String serviceId = config.getServiceId();
			String operationName = config.getOperationName();
			String mappingRuleIdIn = config.getInputMappingRuleId();
			String mappingRuleIdOut = config.getOutputMappingRuleId();
			IMessage sourceMessage = config.getInputMessage();
			result =
				executeOperation(
					(IBusinessObject) object,
					sourceMessage,
					serviceId,
					operationName,
					mappingRuleIdIn,
					mappingRuleIdOut);
			if (result!=null) {
				object = setKeys(result, (IBusinessObject) object, keys.iterator());
			}
				  					
		} catch (Exception e) {
			Object[] args = { object };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error creating Business-Object-Instance of {0}",
				args,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
			throw new DataAccessException(e);
		}

		jdoDataAccessService.create(object);

		String key = object.getKey();
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { key });
		return key;
	}

	public void destroy() {
	}

	public Object execute(
		String action,
		Class objClass,
		Object input,
		Object result)
		throws DataAccessException {
		String method = "execute(String, Class, Object, Object)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { action, objClass, input, result });
		IBusinessObject resultObject;
		try {
			// TODO: action ===> actionType
			int actionType = 0;
			
			ArrayList beCoordinates = RemoteDataAccessService.parseObjectType((IDependentObject)input);
			String provider = (String)beCoordinates.get(0);
			String application = (String)beCoordinates.get(1);
			String beName = (String)beCoordinates.get(2);
			BusinessEntityInterface be = (new MetaModel()).getBusinessEntityInterface(provider, application, beName + "Service");
			
			IExternalOperationConfig config =
				runtimeHelper.getExternalOperationConfig(
					be,
					actionType);
			String serviceId = config.getServiceId();
			String operationName = config.getOperationName();
			String mappingRuleIdIn = config.getInputMappingRuleId();
			String mappingRuleIdOut = config.getOutputMappingRuleId();
			IMessage sourceMessage = config.getInputMessage();
			resultObject =
				executeOperation(
					(IBusinessObject) input,
					sourceMessage,
					serviceId,
					operationName,
					mappingRuleIdIn,
					mappingRuleIdOut);
		} catch (Exception e) {
			Object[] args = { action, objClass, input };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error executing action {0} for type {1} with input {2}",
				args,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
			throw new DataAccessException(e);
		}
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { resultObject });
		return resultObject;
	}

	public Object findByPrimaryKey(Object arg0, Class arg1)
		throws DataAccessException {
		throw new DataAccessException("Operation not Supported");
	}

	public Object load(Object key, Class type) throws DataAccessException {
		String method = "load(Object, Class)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { key, type });
		IBusinessObject jdoObject = (IBusinessObject)jdoDataAccessService.load(key, type);
		List keys;
		IBusinessObject result;
		try {
			ArrayList beCoordinates = RemoteDataAccessService.parseObjectType((IDependentObject)jdoObject);
			String provider = (String)beCoordinates.get(0);
			String application = (String)beCoordinates.get(1);
			String beName = (String)beCoordinates.get(2);
			BusinessEntityInterface be = (new MetaModel()).getBusinessEntityInterface(provider, application, beName + "Service");
			
			keys = be.getBusinessEntity().getKeys();
			IExternalOperationConfig config =
				runtimeHelper.getExternalOperationConfig(
					be,
					IOperationPattern.READ);
			String serviceId = config.getServiceId();
			String operationName = config.getOperationName();
			String mappingRuleIdIn = config.getInputMappingRuleId();
			String mappingRuleIdOut = config.getOutputMappingRuleId();
			IMessage sourceMessage = config.getInputMessage();
			result =
				executeOperation(
					jdoObject,
					sourceMessage,
					serviceId,
					operationName,
					mappingRuleIdIn,
					mappingRuleIdOut);
			if (result == null) {
				result = jdoObject;
			} else {
				result = setKeys(jdoObject, result, keys.iterator());
			}
		} catch (Exception e) {
			Object[] args = { type, key };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error loading Business-Object-Instance of type {0} with key {1}",
				args,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
			throw new DataAccessException(e);
		}
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { result });
		return result;
	}

	private IBusinessObject setKeys(
		IBusinessObject from,
		IBusinessObject to,
		Iterator keys)
		throws Exception {
		IBusinessObject result = to;
		while (keys.hasNext()) {
			String key = ((Attribute) keys.next()).getObjectName();
			Object value = from.getProperty(key);
			if (value!=null) {
				to.setProperty(key, value);
			}
		}
		return result;
	}

	public void passivate() throws DataAccessException {
	}

	public Collection query(Class type, IntQueryFilter filter, String operationName)
		throws DataAccessException {
		String method = "query(Class, IntQueryFilter)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { type, filter });
		Collection result = query(type, new IntQueryFilter[] { filter }, operationName);
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { result });
		return result;
	}

	public Collection query(Class type, IntQueryFilter[] filters, String operationName)
		throws DataAccessException {
		String method = "query(Class, IntQueryFilter[])";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { type, filters });
		MessageEntityConverter msgEntityConverter = MessageEntityConverter.getInstance();
		Set attributes = new HashSet();
		for (int i = 0; i < filters.length; i++) {
			attributes.add(filters[i].getAttribute());
		}
		IExternalOperationConfig config;
		try {
			ArrayList beCoordinates = RemoteDataAccessService.parseObjectType((IDependentObject)type.newInstance());
			String provider = (String)beCoordinates.get(0);
			String application = (String)beCoordinates.get(1);
			String beName = (String)beCoordinates.get(2);
			BusinessEntityInterface be = (new MetaModel()).getBusinessEntityInterface(provider, application, beName + "Service");
			
			config = runtimeHelper.getExternalOperationConfig(be, operationName, attributes);
		} catch (Exception e) {
			Object[] args = { type, filters };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error quering Business-Object-Instance of type {0} with filters {1}",
				args,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
			throw new DataAccessException(e);
		}
		String serviceId = config.getServiceId();
		String extOperationName = config.getOperationName();
		String mappingRuleIdIn = config.getInputMappingRuleId();
		String mappingRuleIdOut = config.getOutputMappingRuleId();
		IMessage sourceMessage = config.getInputMessage();
		IMessageValue responseMessageValue;
		try {
			IMessageValue inputMessageValue = null;
			if (sourceMessage!=null) {
				inputMessageValue = msgEntityConverter.createInputMessageValueFromFilters(filters, sourceMessage);								
			}


		IUserAccount callerAccount = getCallerAccount();
		responseMessageValue =
			dataServiceFactory.executeOperation(
				inputMessageValue,
				mappingRuleIdIn,
				serviceId,
				extOperationName,
				mappingRuleIdOut, 
				callerAccount);

		} catch (Exception e) {
			Object[] args = { type, filters };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error quering Business-Object-Instance of type {0} with filters {1}",
				args,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
			throw new DataAccessException(e);
		}

		Collection result = new ArrayList();
		
		Enumeration messageValueParts =
		    responseMessageValue.getMessagepartValueEnumeration();
		while (messageValueParts.hasMoreElements()) {
			IMessagepartValue messagePartValue =
				(IMessagepartValue) messageValueParts.nextElement();
			location.debugT(
				"Processing message part with name="
					+ messagePartValue.getMessagepart().getName());
			
			String messagePartValueName =
				messagePartValue.getMessagepart().getName();
			IElementValue messagePartStructureValue =
			    (IElementValue) messagePartValue.getStructureValue();
			IElementValue elementValue = ((IComplexTypeValue) messagePartStructureValue.getTypeValue(0)).getElementValue(0);			     
			Enumeration typeValues = elementValue.getTypeValueEnumeration();
			while (typeValues.hasMoreElements()) {									
				IComplexTypeValue complexTypeValue =
					(IComplexTypeValue) typeValues.nextElement();							
				Object current=null;
				try {
					current = type.newInstance();
					current =
						msgEntityConverter.retrieveComplexTypeValue(
							complexTypeValue,
					        current);	
				} catch (Exception e) {
					Object[] args = { type, filters };
					CAFPublicLogger.traceThrowableT(
						Severity.DEBUG,
						location,
						method,
						"Error quering Business-Object-Instance of type {0} with filters {1}",
						args,
						e);
					location.throwing(method, e);
					CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
					throw new DataAccessException(e);
				}
				result.add(current);		
			}			
		}
		Collection processedResults;						
		try {
			if (config.isTransientFindBy()) {
				processedResults = result;
			} else {	
				processedResults = processQueryResults(result, type, operationName);
			}
		} catch (Exception e) {
			Object[] args = { type, filters };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error quering Business-Object-Instance of type {0} with filters {1}",
				args,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
			throw new DataAccessException(e);
		}
		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { result });		
		return processedResults;	
	}
	
	private Collection processQueryResults(Collection results, Class type, String operationName) throws Exception {
		MetaModel metaModel = new MetaModel();
		ArrayList beCoordinates = RemoteDataAccessService.parseObjectType((IDependentObject)type.newInstance());
		String provider = (String)beCoordinates.get(0);
		String application = (String)beCoordinates.get(1);
		String beName = (String)beCoordinates.get(2);
		BusinessEntityInterface bei = 
	        metaModel.getBusinessEntityInterface(provider, application, beName + "Service");
		DataObject dataObject = bei.getBusinessEntity();		             				
		List keys = dataObject.getKeys();
		List attributes = dataObject.getAttributes();
		Collection processedResult = new ArrayList();
		Iterator objects = results.iterator();
		while (objects.hasNext()) {
			Object processedObject = processQueryResult(type, (IBusinessObject)objects.next(), bei, keys, attributes, operationName); 
			processedResult.add(processedObject);
		}
		return processedResult;
	}
	
	private IBusinessObject processQueryResult(Class type, IBusinessObject result, BusinessEntityInterface bei, 
	                                           List keys, List attributes, String operationName) throws Exception {
		IBusinessObject processedResult;
		IBusinessObject jdoObject = findJDOObject(type, result, keys, operationName);
		if (jdoObject==null) { // doesn't exist
			processedResult=result;
			String key = PrimaryKeyFactory.getInstance().getPrimaryKey();
			processedResult.setProperty("key", key);			
			jdoDataAccessService.create(processedResult);
		} else { //exists
			processedResult=jdoObject;
			for (int i=0;i<attributes.size();i++) {
				Attribute attribute = (Attribute) attributes.get(i);
				String attributeName = attribute.getObjectName();
				if (!(attributeName.equals("createdAt") || attributeName.equals("createdBy") ||
				    attributeName.equals("lastChangedAt") || attributeName.equals("lastChangedBy"))) {				    	
				    String attributeType = attribute.getTypeJavaDdic();
					String attributeJavaType;
				    if (attributeType==null) { 
				    	if ((((DataObject)attribute.getReferencedObject()).getBusinessEntityInterface()==null)) {
				    	    // Complex type
							if ((attribute.getMaxOccurs().intValue()>1) || (attribute.getMaxOccurs().intValue()==-1)) {
							    // Complex type with cardinality n
								attributeJavaType = "java.util.Collection";							    	
							} else {
								// Complex type with cardinality 1								
								attributeJavaType = revertDotString(bei.getApplication().getProviderName())
								                    + "." + bei.getApplication().getObjectName().toLowerCase() 
								                    + "besrv" + bei.getObjectName().toLowerCase() 
								                    + "." + attributeName.substring(0, 1).toUpperCase()
								                    + attributeName.substring(1);   								                    																					    	    
							}				    	    
				    	} else {
				    	    // Business Entity Reference - skip it 
				    	    continue;  	
				    	}	
				    } else { // Simple type
				    	if ((attribute.getMaxOccurs().intValue()>1) || (attribute.getMaxOccurs().intValue()==-1)) {
                            // Simple type with cardinality n
                            attributeJavaType = "java.util.Collection";
				    	} else { // Simple type with cardinality 1
							attributeJavaType = convertToJavaType(attributeType);				    		
				    	}
				    }					    					    				    				    				    				    
                    processedResult.setProperty(attributeName,
                    	result.getProperty(attributeName));		
			    }
			}			
		}
		return processedResult; 
	}

	private String revertDotString(String input) {
		String retVal = "";
		int pos1 = 0;
		int pos2 = -1;
		while ((pos2 = input.indexOf('.', pos1)) != -1) {
			retVal = input.substring(pos1, pos2) + retVal;
			pos1 = pos2 + 1;
		}
		retVal = input.substring(pos1) + "." + retVal;
		return retVal;
	}
	
	private String convertToJavaType(String javaDDicType) throws DdException {
		ClassLoader cl     = Thread.currentThread().getContextClassLoader();
		Locale      locale = Locale.getDefault();
		DdDictionaryPool pool = DdDictionaryPool.getInstance();
		IBroker broker = pool.createBroker(cl, locale);
		IDataType dataType = broker.getDataType(javaDDicType);				
		String result = convertDataTypeToJavaType(dataType);
		return result;
	}
	
	private String convertDataTypeToJavaType(IDataType dataType) {
		String result=null;
		
		if (dataType.isSimpleType()) {
			com.sap.dictionary.runtime.ISimpleType simpleType = (com.sap.dictionary.runtime.ISimpleType) dataType;
			String buildInType = simpleType.getBuiltInType();

			if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_BINARY.getName())) {
				result = "byte[]";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_BOOLEAN.getName())) {
				result = "boolean";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_DATE.getName())) {
				result = "java.sql.Date";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_DECIMAL.getName())) {
				result = "java.math.BigDecimal"; 
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_DOUBLE.getName())) {
				result = "double";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_FLOAT.getName())) {
				result = "float";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_INTEGER.getName())) {
				result = "int";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_LONG.getName())) {
				result = "long";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_SHORT.getName())) {
				result = "short";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_STRING.getName())) {
				result = "java.lang.String";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_TIME.getName())) {
				result = "java.sql.Time";
			} else if (buildInType.equals(com.sap.dictionary.runtime.ISimpleType.TYPE_TIMESTAMP.getName())) {
				result = "java.util.Date";
			}
		}						
		return result;
	}
	
	private IBusinessObject findJDOObject(Class type, IBusinessObject object, List keys, String operationName) throws Exception {
		IntQueryFilter[] filters = new IntQueryFilter[keys.size()-1];
		int j=0;
		for (int i=0;i<keys.size();i++) {
			Attribute key = (Attribute) keys.get(i);
			String keyName = key.getObjectName();
			if ("key".equals(keyName))
				continue;
				
			String value = (String)object.getProperty(keyName);
			filters[j] = new IntQueryFilter(new QueryFilter(value));
			filters[j].setAttribute(keyName);									
			j++; 
		}		
		Collection results = jdoDataAccessService.query(type, filters, operationName);
		if (results.isEmpty()) {
			return null;
		} else {
			return (IBusinessObject) results.iterator().next();
		}
	}

	public Collection query(Class arg0, String arg1, String arg2, Map arg3, String operationName)
		throws DataAccessException {
		throw new DataAccessException("Operation not Supported");
	}

	public Collection query(Class arg0, String operationName) throws DataAccessException {
		throw new DataAccessException("Operation not Supported");
	}

	public Collection query(String arg0, Class arg1, IntQueryFilter[] arg2, String operationName)
		throws DataAccessException {
		throw new DataAccessException("Operation not Supported");
	}

	public void remove(IDependentObject object) throws DataAccessException {
		String method = "remove(IDependentObject)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { object });
		try {
			ArrayList beCoordinates = RemoteDataAccessService.parseObjectType(object);
			String provider = (String)beCoordinates.get(0);
			String application = (String)beCoordinates.get(1);
			String beName = (String)beCoordinates.get(2);
			BusinessEntityInterface be = (new MetaModel()).getBusinessEntityInterface(provider, application, beName + "Service");
			
			IExternalOperationConfig config =
				runtimeHelper.getExternalOperationConfig(
					be,
					IOperationPattern.DELETE);
			String serviceId = config.getServiceId();
			String operationName = config.getOperationName();
			String mappingRuleIdIn = config.getInputMappingRuleId();
			String mappingRuleIdOut = config.getOutputMappingRuleId();
			IMessage sourceMessage = config.getInputMessage();
			executeOperation(
				(IBusinessObject) object,
				sourceMessage,
				serviceId,
				operationName,
				mappingRuleIdIn,
				mappingRuleIdOut);
		} catch (Exception e) {
			Object[] args = { object };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error removing Business-Object-Instance {0}",
				args,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
			throw new DataAccessException(e);
		}
		jdoDataAccessService.remove(object);
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
	}

	public void store(IDependentObject object) throws DataAccessException {
		String method = "store(IDependentObject)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { object });
		try {
			ArrayList beCoordinates = RemoteDataAccessService.parseObjectType(object);
			String provider = (String)beCoordinates.get(0);
			String application = (String)beCoordinates.get(1);
			String beName = (String)beCoordinates.get(2);
			BusinessEntityInterface be = (new MetaModel()).getBusinessEntityInterface(provider, application, beName + "Service");
			
			IExternalOperationConfig config =
				runtimeHelper.getExternalOperationConfig(
					be,
					IOperationPattern.UPDATE);
			String serviceId = config.getServiceId();
			String operationName = config.getOperationName();
			String mappingRuleIdIn = config.getInputMappingRuleId();
			String mappingRuleIdOut = config.getOutputMappingRuleId();
			IMessage sourceMessage = config.getInputMessage();
			executeOperation(
				(IBusinessObject) object,
				sourceMessage,
				serviceId,
				operationName,
				mappingRuleIdIn,
				mappingRuleIdOut);
		} catch (Exception e) {
			Object[] args = { object };
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error storing Business-Object-Instance {0}",
				args,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
			throw new DataAccessException(e);
		}
		jdoDataAccessService.store(object);
		CAFPublicLogger.exiting(null, JARM_REQUEST, method, location);
	}


	/**
	 * Call this method to obtain the IUserAccount of the caller. 
	 * 
	 * @return return 
	 * 				the account of the caller. This account contains 
	 * 				client certificates needed for SSO. Returnes null if 
	 * 				something goes wrang.  
	 * @author nikolay-k (i030736) 
	 */
	private IUserAccount getCallerAccount() {
		/* Get the caller account from the Runtime context Context Bean wich 
		 * was initialized in com.sap.caf.rt.srv.ApplicationServiceBean#ejbActivate() and 
		 * com.sap.caf.rt.bol.EntityServiceBean#ejbActivate(
		 */
		IUserAccount callerAccount= null;
	  try {
		  InitialContext ic = new InitialContext();
		  RTContextLocalHome home = (RTContextLocalHome)
			  ic.lookup("localejbs/" + RTContextLocalHome.JNDI_NAME);
		  RTContextLocal rtContext = home.create();
			String callerPrincipalName = rtContext.getCallerPrincipalName();
			callerAccount = 
			  UMFactory.getUserAccountFactory().getUserAccountByLogonId(callerPrincipalName);
	  } catch (Exception ex) {
			callerAccount = null;
	  }
	  return callerAccount;

	}

}