/*
 * Created on Aug 3, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.rt.bol.da.remote;


import java.lang.reflect.Method;

import java.math.BigDecimal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

import com.sap.caf.mp.base.exception.InvocationException;

import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;

import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;

import com.sap.caf.mp.core.data.values.base.ComplexTypeValue;
import com.sap.caf.mp.core.data.values.base.ElementValue;
import com.sap.caf.mp.core.data.values.base.MessageValue;
import com.sap.caf.mp.core.data.values.base.MessagepartValue;
import com.sap.caf.mp.core.data.values.base.SimpleTypeValue;

import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;

import com.sap.caf.rt.bol.util.IntQueryFilter;

import com.sap.tc.logging.Location;


/**
 * @author trendafil-m
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class MessageEntityConverter {

	private static final Location location = Location.getLocation(MessageEntityConverter.class);

    private static MessageEntityConverter converter;    
    
    private MessageEntityConverter() {
    }
    
    public static MessageEntityConverter getInstance() {
    	if (converter==null) {
    		converter = new MessageEntityConverter();
    	}
    	return converter;
    }

	public IMessageValue createInputMessageValue(Object input, IMessage inputMessage) 
	                     throws InvocationException {
		location.debugT("Entering createInputMessageValue()");
		MessageValue inputMessageValue = new MessageValue(inputMessage);
		Enumeration messageParts = inputMessage.getMessagepartEnumeration();
		while (messageParts.hasMoreElements()) {
			// The only messagepart should be 'parameters'
			IMessagepart messagePart = (IMessagepart) messageParts.nextElement();
			location.debugT("Processing message part with name=" + messagePart.getName());
			IMessagepartValue messagePartValue = new MessagepartValue(messagePart);		
			IStructure messagePartStructure = messagePart.getStructure();
			// The messagepart 'parameters' should contain a single element with complex
			// type named by the operation name
			IElement messagePartElement = (IElement) messagePartStructure;						
			location.debugT("Processing element with name=" + messagePartElement.getName());			
			IElementValue elementValue = new ElementValue(messagePartElement);
			IType elementType = messagePartElement.getType();
			IComplexType elementComplexType = (IComplexType) elementType;						
			IComplexTypeValue complexTypeValue = new ComplexTypeValue(elementComplexType);
			Enumeration elements = elementComplexType.getElementEnumeration();
			while (elements.hasMoreElements()) {
				IElement element = (IElement) elements.nextElement();
				location.debugT("Processing element with name=" + element.getName());				
				IElementValue value = createElementValue(input, element);
				complexTypeValue.addElementValue(value);
			}			
			elementValue.addTypeValue(complexTypeValue);									
			messagePartValue.setStructureValue(elementValue);						
			inputMessageValue.addMessagepartValue(messagePartValue);
		}
		location.debugT("Exiting createInputMessageValue()");
		return inputMessageValue;			    
	}
		
	private IElementValue createElementValue(Object input, IElement element)
	                      throws InvocationException {	
		location.debugT("Entering createElementValue()");
		String elementName = element.getName();
		location.debugT("Processing element with name=" + elementName);
		IElementValue elementValue = new ElementValue(element);
		if (input != null)
		{
			IType elementType = element.getType();
			Object value = getValue(input, elementName);
			int maxOccurs = element.getMaxOccurs();
			if (elementType instanceof IComplexType) {
				location.debugT("Element type is complex type");
				IComplexType elementComplexType = (IComplexType) elementType;
				if (maxOccurs==1) {
					IComplexTypeValue complexTypeValue = createComplexTypeValue(value, elementComplexType);			
					elementValue.addTypeValue(complexTypeValue);							
				} else {
					Iterator valuesIter = ((Collection)value).iterator();
					while (valuesIter.hasNext()) {
						Object current = valuesIter.next();
						IComplexTypeValue complexTypeValue = createComplexTypeValue(current, elementComplexType);			
						elementValue.addTypeValue(complexTypeValue);					
					}
				}
			} else if (elementType instanceof ISimpleType) {
				location.debugT("Element type is simple type");
				ISimpleType elementSimpleType = (ISimpleType) elementType;			
				if (maxOccurs==1) {						
					ISimpleTypeValue simpleTypeValue = createSimpleTypeValue(value,	elementSimpleType);
					elementValue.addTypeValue(simpleTypeValue);
				} else {
					Iterator valuesIter = ((Collection)value).iterator();
					while (valuesIter.hasNext()) {
						Object current = valuesIter.next();
						ISimpleTypeValue simpleTypeValue = createSimpleTypeValue(current, elementSimpleType);			
						elementValue.addTypeValue(simpleTypeValue);					
					}				
				}
			}
		}
		location.debugT("Exiting createElementValue()");
		return elementValue;	
	}
	
	private IComplexTypeValue createComplexTypeValue(Object input,	IComplexType complexType) 
		                      throws InvocationException {		
		location.debugT("Entering createComplexTypeValue()");
		IComplexTypeValue complexTypeValue = new ComplexTypeValue(complexType);
		Enumeration elements = complexType.getElementEnumeration();
		while (elements.hasMoreElements()) {
			IElement element = (IElement) elements.nextElement();
			IElementValue elementValue = createElementValue(input, element);
			complexTypeValue.addElementValue(elementValue);
		}
		location.debugT("Exiting createComplexTypeValue()");
		return complexTypeValue;	
	}
	
	private ISimpleTypeValue createSimpleTypeValue(Object input, ISimpleType simpleType)
	                         throws InvocationException {	
		location.debugT("Entering createSimpleTypeValue()");
		ISimpleTypeValue simpleTypeValue = new SimpleTypeValue(simpleType);
		int base = simpleType.getBase();
		location.debugT("Base type number=" + base);
		switch (base) {
			case ISimpleType.BASE_BASE64BINARY :
				location.debugT("Base type is base64binary");
				simpleTypeValue.setValueByteArray((byte[])input);
				break;
			case ISimpleType.BASE_BOOLEAN :
				location.debugT("Base type is boolean");
				simpleTypeValue.setValueBoolean((Boolean)input);
				break;
			case ISimpleType.BASE_BYTE :
				location.debugT("Base type is byte");
				simpleTypeValue.setValue(input.toString());
				break;
			case ISimpleType.BASE_DATE :
				location.debugT("Base type is date");
				simpleTypeValue.setValueDate((Date)input);
				break;
			case ISimpleType.BASE_DECIMAL :
				location.debugT("Base type is decimal");
				simpleTypeValue.setValueBigDecimal((BigDecimal)input);
				break;
			case ISimpleType.BASE_DOUBLE :
				location.debugT("Base type is double");
				simpleTypeValue.setValueDouble((Double)input);
				break;
			case ISimpleType.BASE_FLOAT :
				location.debugT("Base type is float");
				simpleTypeValue.setValue(input.toString());
				break;
			case ISimpleType.BASE_INT :
				location.debugT("Base type is int");
				simpleTypeValue.setValueInteger((Integer)input);
				break;
			case ISimpleType.BASE_INTEGER :
				location.debugT("Base type is integer");
				simpleTypeValue.setValueInteger((Integer)input);
				break;
			case ISimpleType.BASE_LONG :
				location.debugT("Base type is long");
				simpleTypeValue.setValue(input.toString());
				break;
			case ISimpleType.BASE_SHORT :
				location.debugT("Base type is short");
				simpleTypeValue.setValue(input.toString());
				break;
			case ISimpleType.BASE_STRING :
				location.debugT("Base type is string");
				simpleTypeValue.setValueString((String)input);
				break;
			case ISimpleType.BASE_TIME :
				location.debugT("Base type is time");
				simpleTypeValue.setValueDate((Date)input);
				break;
			case ISimpleType.BASE_TIMESTAMP :
				location.debugT("Base type is timestamp");
				simpleTypeValue.setValueDate((Date)input);
				break;
			case ISimpleType.BASE_UNSIGNED_BYTE :
				location.debugT("Base type is unsigned byte");
				simpleTypeValue.setValue(input.toString());
				break;
			case ISimpleType.BASE_UNSIGNED_INT :
				location.debugT("Base type is unsigned int");
				simpleTypeValue.setValue(input.toString());
				break;
			case ISimpleType.BASE_UNSIGNED_LONG :
				location.debugT("Base type is unsigned long");
				simpleTypeValue.setValue(input.toString());
				break;
			case ISimpleType.BASE_UNSIGNED_SHORT :
				location.debugT("Base type is unsigned short");
				simpleTypeValue.setValue(input.toString());
				break;
			default :
				throw new InvocationException("Unknown simple type.");
		}
		location.debugT("Exiting createSimpleTypeValue()");
		return simpleTypeValue;	
	}
	
	private Object getValue(Object object, String attributeName) throws InvocationException {	
		Object result;
		try {
			if (object instanceof IDependentObject)
			{
				result = ((IDependentObject)object).getProperty(attributeName);
			}
			else
			{
				Method method =	object.getClass().getMethod(
						"get" + capitalize(constructJavaIdentifier(attributeName)),
						new Class[0]);
				result = method.invoke(object, new Object[0]);
			} 
		} catch (Exception e) {
			throw new InvocationException(e);
		}				
		return result;
	}
	
	public IMessageValue createInputMessageValueFromFilters(IntQueryFilter[] filters, IMessage inputMessage)
		                  throws InvocationException {
		location.debugT("Entering createInputMessageValueFromFilters()");
		MessageValue inputMessageValue = new MessageValue(inputMessage);
		Enumeration messageParts = inputMessage.getMessagepartEnumeration();
		while (messageParts.hasMoreElements()) {
			IMessagepart messagePart = (IMessagepart) messageParts.nextElement();
			location.debugT("Processing message part with name=" + messagePart.getName());
			IMessagepartValue messagePartValue = createInputMessagePartValueFromFilters(filters, messagePart);
			inputMessageValue.addMessagepartValue(messagePartValue);
		}				
		location.debugT("Exiting createInputMessageValueFromFilters()");
		return inputMessageValue;
	}	
	
	private IMessagepartValue createInputMessagePartValueFromFilters(IntQueryFilter[] filters, IMessagepart messagePart)
	             	          throws InvocationException {
		location.debugT("Entering createInputMessagePartValueFromFilters()");
		MessagepartValue messagePartValue = new MessagepartValue(messagePart);		
		IStructure messagePartStructure = messagePart.getStructure();
		IElement messagePartElement = (IElement) messagePartStructure;
		IElementValue elementValue = createElementValueFromFilters(filters, messagePartElement);
		messagePartValue.setStructureValue(elementValue);						
		location.debugT("Exiting createInputMessagePartValueFromFilters()");
		return messagePartValue;
	}	
	
	private IElementValue createElementValueFromFilters(IntQueryFilter[] filters, IElement element)
		                  throws InvocationException {
		location.debugT("Entering createElementValueFromFilters()");		
		String elementName = element.getName();
		location.debugT("Processing element with name=" + elementName);
		IElementValue elementValue = new ElementValue(element);
		IType elementType = element.getType();
		location.debugT("Element type is complex type");
		IComplexType elementComplexType = (IComplexType) elementType;
		IComplexTypeValue complexTypeValue = createComplexTypeValueFromFilters(filters,	elementComplexType);
		elementValue.addTypeValue(complexTypeValue);		
		location.debugT("Exiting createElementValueFromFilters()");
		return elementValue;
	}	
	
	private IComplexTypeValue createComplexTypeValueFromFilters(IntQueryFilter[] filters, IComplexType complexType)
		                      throws InvocationException {
		location.debugT("Entering createComplexTypeValueFromFilters()");
		IComplexTypeValue complexTypeValue = new ComplexTypeValue(complexType);		
		for (int i=0;i<filters.length;i++) {
			IElement element = complexType.getElement(filters[i].getAttribute());
			IElementValue elementValue = createFilterElementValue(filters[i], element);
			complexTypeValue.addElementValue(elementValue);									
		}									
		location.debugT("Exiting createComplexTypeValueFromFilters()");
		return complexTypeValue;		
	}	
	
	private IElementValue createFilterElementValue(IntQueryFilter filter, IElement element)
		                  throws InvocationException {
		location.debugT("Entering createFilterElementValue()");	
		String elementName = element.getName();
		location.debugT("Processing element with name=" + elementName);
		IElementValue elementValue = new ElementValue(element);
		IType elementType = element.getType();
		location.debugT("Element type is complex type");
		IComplexType elementComplexType = (IComplexType) elementType;
		IComplexTypeValue complexTypeValue = createComplexTypeValueFromFilter(filter, elementComplexType);
		elementValue.addTypeValue(complexTypeValue);		
		location.debugT("Exiting createFilterElementValue()");
		return elementValue;
	}	
	
	private IComplexTypeValue createComplexTypeValueFromFilter(IntQueryFilter filter, IComplexType complexType)
		                      throws InvocationException {
		location.debugT("Entering createComplexTypeValueFromFilter()");				
		IComplexTypeValue complexTypeValue = new ComplexTypeValue(complexType);		
		IElement elementLow = complexType.getElement("minValue");
		IElementValue elementLowValue = createSimpleTypeElementValue(filter.getAttributeValue().toString(), elementLow);
		complexTypeValue.addElementValue(elementLowValue);		
		IElement elementHigh = complexType.getElement("maxValue");
		IElementValue elementHighValue = createSimpleTypeElementValue(filter.getAttributeValueHigh().toString(), elementHigh);
		complexTypeValue.addElementValue(elementHighValue);
		IElement elementCondition = complexType.getElement("option");
		IElementValue elementConditionValue = createSimpleTypeElementValue(filter.condition, elementCondition);
		complexTypeValue.addElementValue(elementConditionValue);																						
		location.debugT("Exiting createComplexTypeValueFromFilter()");
		return complexTypeValue;
	}	
	
	private IElementValue createSimpleTypeElementValue(String value, IElement element)
		                  throws InvocationException {
		location.debugT("Entering createSimpleTypeElementValue()");				
		String elementName = element.getName();
		location.debugT("Processing element with name=" + elementName);		
		IElementValue elementValue = new ElementValue(element);
		ISimpleTypeValue simpleTypeValue = new SimpleTypeValue((ISimpleType)element.getType());		
		simpleTypeValue.setValueString(value);				
		elementValue.addTypeValue(simpleTypeValue);						
		location.debugT("Exiting createSimpleTypeElementValue()");
		return elementValue;
	}	
	
	public IBusinessObject createOutputBusinessObject(IMessageValue messageValue, Class objectClass)
		                   throws InvocationException {
		location.debugT("Entering createOutputBusinessObject()");
		IBusinessObject result = null;
		try {
			result = (IBusinessObject) objectClass.newInstance();
		} catch (Exception e) {
			throw new InvocationException(e);
		}
		result = (IBusinessObject) retrieveMessageValue(messageValue, result);
		location.debugT("Exiting createOutputBusinessObject()");
		return result;
	}	
	
	public Object retrieveMessageValue(IMessageValue messageValue, Object object)
		           throws InvocationException {
		location.debugT("Entering retrieveMessageValue()");
		Object result = null;
		if (messageValue != null) {
			result = object;
			Enumeration messageValueParts =	messageValue.getMessagepartValueEnumeration();
			while (messageValueParts.hasMoreElements()) {
	            // The only messagepart value should be 'parameters'
				IMessagepartValue messagePartValue = (IMessagepartValue) messageValueParts.nextElement();
				location.debugT("Processing message part with name=" + messagePartValue.getMessagepart().getName());
				
				IStructureValue messagePartStructureValue =	messagePartValue.getStructureValue();
				// The messagepart 'parameters' should contain a single element with complex
				// type named by the operation name			
				IElementValue elementValue = (IElementValue) messagePartStructureValue;
				location.debugT("Processing element with name=" + elementValue.getElement().getName());
				IComplexTypeValue elementTypeValue = (IComplexTypeValue) elementValue.getTypeValue(0);
				Enumeration elements = elementTypeValue.getElementValueEnumeration();
				while (elements.hasMoreElements()) { 
				   IElementValue value = (IElementValue) elements.nextElement();
				   location.debugT("Processing element with name=" + value.getElement().getName());
				   result = retrieveElementValue(value, result);							   	
				}												
			}
		}
		location.debugT("Exiting retrieveMessageValue()");
		return result;
	}	
		
	private Object retrieveElementValue(IElementValue elementValue, Object object)
		           throws InvocationException {
		location.debugT("Entering retrieveElementValue()");
		String elementValueName = elementValue.getElement().getName();
		location.debugT("Processing element with name=" + elementValueName);
		Object result = object;		
		IElement element = elementValue.getElement();
		String elementName = element.getName();
		IType elementType = element.getType();
		int maxOccurs = element.getMaxOccurs();				
		if (elementType instanceof IComplexType) {
			location.debugT("Element type is complex type");
			if (maxOccurs==1) {
				IComplexTypeValue elementComplexTypeValue = (IComplexTypeValue) elementValue.getTypeValue(0);	
				if (elementComplexTypeValue != null)
				{			
					Object complexAttribute = createNewInstance(object.getClass(), elementName, object.getClass().getClassLoader());				
					complexAttribute = retrieveComplexTypeValue(elementComplexTypeValue, complexAttribute);
					setValue(result, complexAttribute, elementName);
				}
			} else {
				Enumeration typeValues = elementValue.getTypeValueEnumeration();
				Object complexAttribute;
				Collection values = new ArrayList();
				while (typeValues.hasMoreElements())
				{
				    IComplexTypeValue typeValue = (IComplexTypeValue) typeValues.nextElement();
				    if (typeValue != null)
				    {
						complexAttribute = createNewInstance(object.getClass(), elementName, object.getClass().getClassLoader());
					    complexAttribute = retrieveComplexTypeValue(typeValue, complexAttribute);
					    values.add(complexAttribute);
				    }
				}
                setCollection(result, values, element.getName()); 
			}
		} else if (elementType instanceof ISimpleType) {
			location.debugT("Element type is simple type");			
			if (maxOccurs==1) {				
				ISimpleTypeValue elementSimpleTypeValue = (ISimpleTypeValue) elementValue.getTypeValue(0);
				if (elementSimpleTypeValue != null)
				{
					setValue(result, elementSimpleTypeValue, elementName);
				}
			} else {
				Enumeration typeValues = elementValue.getTypeValueEnumeration();
				Collection values = new ArrayList();
				while (typeValues.hasMoreElements()) {
				    ISimpleTypeValue typeValue = (ISimpleTypeValue) typeValues.nextElement();
				    Object simpleAttribute = retrieveSimpleTypeValue(typeValue);
				    values.add(simpleAttribute);                
				}
				setCollection(result, values, elementName);				
			}
		}				
		location.debugT("Exiting retrieveElementValue()");
		return result;
	}		
	
	public Object retrieveComplexTypeValue(
		IComplexTypeValue complexTypeValue,	Object object)
		           throws InvocationException {		           	
		location.debugT("Entering retrieveComplexTypeValue()");
		
		Object result = object;
		Enumeration elementValues =	complexTypeValue.getElementValueEnumeration();
		while (elementValues.hasMoreElements()) {
			IElementValue elementValue = (IElementValue) elementValues.nextElement();
			result = retrieveElementValue(elementValue, result);
		}
		location.debugT("Exiting retrieveComplexTypeValue()");
		return result;		           	
    }	       
    
	private Object retrieveSimpleTypeValue(ISimpleTypeValue simpleTypeValue)
		           throws InvocationException {        
        return getValueAndClass(simpleTypeValue).getValue();		           	
    }	           	
    
	private void setValue(Object object, ISimpleTypeValue value, String attributeName)
		           throws InvocationException {
		location.debugT("Entering setValue()");
		ValueClass valueClass = getValueAndClass(value);		
		Class objectClass = valueClass.getObjectClass();
		Object objectValue = valueClass.getValue();
		location.debugT("value=" + objectValue);
		try {
			if (object instanceof IDependentObject)
			{
				((IDependentObject)object).setProperty(attributeName, objectValue);
			}
			else
			{
				Method method =	object.getClass().getMethod(
					"set" + capitalize(constructJavaIdentifier(attributeName)),
					new Class[] { objectClass });
				method.invoke(object, new Object[] { objectValue });
			}
		} catch (Exception e) {
			throw new InvocationException(e);
		}
		location.debugT("Exiting setValue()");
	}
	
	private ValueClass getValueAndClass(ISimpleTypeValue value)
	                   throws InvocationException {	
		Class objectClass = null;
		Object objectValue = null;		
		int base = value.getSimpleType().getBase();
		location.debugT("Base type number=" + base);
		switch (base) {
			case ISimpleType.BASE_BASE64BINARY :
				location.debugT("Base type is base64binary");
				objectClass = byte[].class;
				objectValue = value.getValueByteArray();
				break;
			case ISimpleType.BASE_BOOLEAN :
				location.debugT("Base type is boolean");
				objectClass = boolean.class;
				objectValue = value.getValueBoolean();						
						
				break;
			case ISimpleType.BASE_BYTE :
				location.debugT("Base type is byte");
				objectClass = byte.class;
				objectValue = new Byte((value.getValue()));
				break;
			case ISimpleType.BASE_DATE :
				location.debugT("Base type is date");
				objectClass = Date.class;
				objectValue = value.getValueDate();
				break;
			case ISimpleType.BASE_DECIMAL :
				location.debugT("Base type is decimal");
				objectClass = BigDecimal.class;
				objectValue = value.getValueBigDecimal();
				break;
			case ISimpleType.BASE_DOUBLE :
				location.debugT("Base type is double");
				objectClass = double.class;
				objectValue = value.getValueDouble();
				break;
			case ISimpleType.BASE_FLOAT :
				location.debugT("Base type is float");
				objectClass = float.class;
				objectValue = new Float(value.getValue());
				break;
			case ISimpleType.BASE_INT :
				location.debugT("Base type is int");
				objectClass = int.class;
				objectValue = value.getValueInteger();
				break;
			case ISimpleType.BASE_INTEGER :
				location.debugT("Base type is integer");
				objectClass = Integer.class;
				objectValue = value.getValueInteger();
				break;
			case ISimpleType.BASE_LONG :
				location.debugT("Base type is long");
				objectClass = long.class;
				objectValue = new Long(value.getValue());
				break;
			case ISimpleType.BASE_SHORT :
				location.debugT("Base type is short");
				objectClass = short.class;
				objectValue = new Short(value.getValue());
				break;
			case ISimpleType.BASE_STRING :
				location.debugT("Base type is string");
				objectClass = String.class;
				objectValue = value.getValueString();
				break;
			case ISimpleType.BASE_TIME :
				location.debugT("Base type is time");
				objectClass = Date.class;
				objectValue = value.getValueDate();
				break;
			case ISimpleType.BASE_TIMESTAMP :
				location.debugT("Base type is timestamp");
				objectClass = Date.class;
				objectValue = value.getValueDate();
				break;
			case ISimpleType.BASE_UNSIGNED_BYTE :
				location.debugT("Base type is unsigned byte");
				objectClass = byte.class;
				objectValue = new Byte(value.getValue());
				if (((Byte) objectValue).byteValue() < 0)
					throw new InvocationException("Base type is unsigned but value is negative.");
				break;
			case ISimpleType.BASE_UNSIGNED_INT :
				location.debugT("Base type is unsigned int");
				objectClass = int.class;
				objectValue = value.getValueInteger();
				if (((Integer) objectValue).intValue() < 0)
					throw new InvocationException("Base type is unsigned but value is negative.");
				break;
			case ISimpleType.BASE_UNSIGNED_LONG :
				location.debugT("Base type is unsigned long");
				objectClass = long.class;
				objectValue = new Long(value.getValue());
				if (((Long) objectValue).longValue() < 0)
					throw new InvocationException("Base type is unsigned but value is negative.");
				break;
			case ISimpleType.BASE_UNSIGNED_SHORT :
				location.debugT("Base type is unsigned short");
				objectClass = short.class;
				objectValue = new Short(value.getValue());
				if (((Short) objectValue).shortValue() < 0)
					throw new InvocationException("Base type is unsigned but value is negative.");
				break;
			default :
				throw new InvocationException("Unknown simple type.");
		}		
		ValueClass result = new ValueClass();
		result.setObjectClass(objectClass);
		result.setValue(objectValue);
		return result;
	}
	
	private void setValue(Object object, Object value, String attributeName)
	    		throws InvocationException {
		try {
			if (object instanceof IDependentObject)
			{
				((IDependentObject)object).setProperty(attributeName, value);
			}
			else
			{
				Method method =	object.getClass().getMethod(
					"set" + capitalize(constructJavaIdentifier(attributeName)),
					new Class[] { value.getClass() });
				method.invoke(object, new Object[] { value });
			}
		} catch (Exception e) {
			throw new InvocationException(e);
		}
	}	
	
	private void setCollection(Object object, Collection collection, String attributeName)
			   throws InvocationException {
		try {
			if (object instanceof IDependentObject)
			{
				((IDependentObject)object).setProperty(attributeName, collection);
			}
			else
			{
				Method method =	object.getClass().getMethod(
					"set" + capitalize(constructJavaIdentifier(attributeName)),
					new Class[] { Collection.class });
				method.invoke(object, new Object[] { collection });
			}
		} catch (Exception e) {
			throw new InvocationException(e);
		}		
	}
	
	private Object createNewInstance(Class parentClass, String className, ClassLoader classLoader)
	               throws InvocationException {	
		try {
			Class objectClass =	classLoader.loadClass(parentClass.getName() + '$'	+ capitalize(constructJavaIdentifier(className)));
			return objectClass.newInstance(); 
		} catch (Exception e) {
			try {
				Class objectClass =	classLoader.loadClass(parentClass.getPackage().getName() + '.'	+ capitalize(constructJavaIdentifier(className)));
				return objectClass.newInstance();
			} catch (Exception ex) {
				throw new InvocationException(ex);
			}
		}                         
	}
	
	// Helper class for (value, type) pair
	class ValueClass {
		private Object value;
		private Class objectClass;
		
		public Class getObjectClass() {
			return objectClass;
		}

		public Object getValue() {
			return value;
		}

		public void setObjectClass(Class class1) {
			objectClass = class1;
		}

		public void setValue(Object object) {
			value = object;
		}
	}
	
	/** 
	 * Restricton for words that can broke generation (Application name, operation name and so on).
	 */
	private static final String[] keywordRestrictions =
		new String[] {
			"abstract",
			"default",
			"if",
			"private",
			"this",
			"boolean",
			"do",
			"implements",
			"protected",
			"throw",
			"break",
			"double",
			"import",
			"public",
			"throws",
			"byte",
			"else",
			"instanceof",
			"return",
			"transient",
			"case",
			"extends",
			"int",
			"short",
			"try",
			"catch",
			"final",
			"interface",
			"static",
			"void",
			"char",
			"finally",
			"long",
			"strictfp",
			"volatile",
			"class",
			"float",
			"native",
			"super",
			"while",
			"const",
			"for",
			"new",
			"switch",
			"continue",
			"goto",
			"package",
			"synchronized",
			};

	/**
	 * Checks if given member name is valid.
	 *
	 * @param memberName - member name.
	 *
	 * @return true if name is not null and is not in keywordRestrictions array.
	 */
	private static boolean isValidMemberName(String memberName) {
		if (memberName == null) {
			return false;
		} else if (isInsideTheArray(memberName, keywordRestrictions)) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 * If a given word is reserved , then it is concatenated with "_"
	 *
	 * @param param - the word that is checked.
	 *
	 * @return if is reserved word then _param is returned else just param
	 */
	private static String escapeJavaReservedWords(String param) {
		if (!isValidMemberName(param)) {
			return "_" + param;
		}

		return param;
	}

	private static String constructJavaIdentifier(String s) {
		if ((s == null) || s.length() == 0)
			return null;
		StringBuffer result = new StringBuffer();

		if ((!Character.isJavaIdentifierStart(s.charAt(0))) || (s.charAt(0) == '$') || (s.charAt(0) == '_'))
			result.append(escapeSequence(s.charAt(0)));
		else
			result.append(s.charAt(0));
		for (int i = 1; i < s.length(); i++) {
			if ((!Character.isJavaIdentifierPart(s.charAt(i)))  || (s.charAt(i) == '$') || (s.charAt(i) == '_'))
				result.append(escapeSequence(s.charAt(i)));
			else
				result.append(s.charAt(i));
		}
		return escapeJavaReservedWords(result.toString());
	}

	private static String escapeSequence(char c) {
		switch (c) {
			case '_' :
				return "__";
			case '$' :
				return "_dol_";
			case '/' :
				return "_sh_";
			case ':' :
				return "_";
			case '.' :
				return "_dot_";
			case '-' :
				return "_minus_";
			default :
				return "_" + String.valueOf((int) c)+"_";
		}
	}

	/**
	 * Check if a given word is inside a given array.
	 *
	 * @param attribute - word that is going to be checked
	 * @param array - array with reserved words
	 *
	 * @return true if array contains this word
	 */
	private static boolean isInsideTheArray(String attribute, String[] array) {
		for (int i = 0; i < array.length; i++) {
			if (array[i].equals(attribute)) {
				return true;
			}
		}

		return false;
	}

	private static String capitalize(String str)
	{
		int strLen;
		if (str == null || (strLen = str.length()) == 0)
		{
			return str;
		}
		return new StringBuffer(strLen)
			.append(Character.toTitleCase(str.charAt(0)))
			.append(str.substring(1))
			.toString();
	}
}