package com.sap.caf.rt.bol.da;

import java.util.Collection;
import java.util.Map;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.util.IntQueryFilter;
import com.sap.caf.rt.bol.util.UserContext;
import com.sap.caf.rt.exception.DataAccessException;

public interface IDataAccessService extends java.io.Serializable {

	public void destroy();

	// public void create(IDependentObject obj) throws DataAccessException;
	public String create(IDependentObject obj) throws DataAccessException;
	public void remove(IDependentObject obj) throws DataAccessException;

	public Object findByPrimaryKey(Object objId, Class objectClass)
		throws DataAccessException;
	//public Object findById(Object objId, Class objectClass);
	public Collection query(Class objectClass, String operationName) throws DataAccessException;
	public Collection query(Class objectClass, String filter, String param, Map hm, String operationName)
		throws DataAccessException;
	public Collection query(Class objectClass, IntQueryFilter filter, String operationName)
				throws DataAccessException;
	public Collection query(Class objectClass, IntQueryFilter[] filter, String operationName)
					throws DataAccessException;

	public Collection query(String usage, Class objectClass, IntQueryFilter[] filter, String operationName)
				throws DataAccessException;
				
	public Object load(Object objId, Class objClass) throws DataAccessException;
	public void store(IDependentObject obj) throws DataAccessException;

	public void activate();
	public void passivate() throws DataAccessException;

	public Object execute(String action, Class objClass, Object input, Object result) throws DataAccessException;

	public void setUserContext(UserContext userContext);
}
