/*
 * Created on 30-Jun-03
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.bol.da;

import java.util.ArrayList;
import java.util.List;

import com.sap.caf.rt.bol.IDependentObject;

/**
 * @author d025479
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class DataStoreQueue {
	private static ThreadLocal queue = new ThreadLocal();
	private List newInstances;
	private List dirtyInstances;
	private List deletedInstances;
	private IDataAccessService da;
	
	public DataStoreQueue() {
		newInstances = new ArrayList();
		dirtyInstances = new ArrayList();
		deletedInstances = new ArrayList();
	}
	
	public void registerNew(IDependentObject obj){
		if (!newInstances.contains(obj))
			newInstances.add(obj);
	}
	
	public void registerDirty(IDependentObject obj){
		if (!dirtyInstances.contains(obj) && 
			!newInstances.contains(obj))
			dirtyInstances.add(obj);
	}
	
	public void registerDeleted(IDependentObject obj){
		if (newInstances.remove(obj))
			return;
		dirtyInstances.remove(obj);
		if (!deletedInstances.contains(obj))
			deletedInstances.add(obj);
	}
	
	public void unregister(IDependentObject obj){
		if (deletedInstances.remove(obj))
			return;
		if (newInstances.remove(obj))
			return;
		dirtyInstances.remove(obj);
	}
	
	public List getNewInstances(){
		return newInstances;
	}
	
	public List getDirtyInstances(){
		return dirtyInstances;
	}
	
	public List getDeletedInstances(){
		return deletedInstances;
	}
	 public boolean isEmpty() {
	 	return (newInstances.isEmpty() && dirtyInstances.isEmpty());
	 }
	
}
