package com.sap.caf.rt.bol.da;

import javax.naming.Context;

import com.sap.caf.rt.bol.da.jdo.JDODataAccessService;
//import com.sap.caf.rt.bol.da.km.KMDataAccessService;
import com.sap.caf.rt.bol.da.remote.RemoteDataAccessService;
import com.sap.caf.rt.exception.DataAccessException;

public class DataAccessFactory {
	public static int DATASOURCE_LOCAL = 1;
	public static int DATASOURCE_REMOTE = 2;
	public static int DATASOURCE_KM = 3;
	public static int DATASOURCE_BW = 4;
	public static int DATASOURCE_WAS = 5;
	public static int DATASOURCE_WEB = 6;
	
	private static DataAccessFactory singletonDataAccessFactory = null;
	/*static {
		try {
		singletonDataAccessFactory = new DataAccessFactory();
		} catch (Exception e) {
			try {
				throw new DataAccessException(e);
			} catch (Exception we) {}
		}
	}*/
	
	private static Context jndiCtx;

	private DataAccessFactory() throws DataAccessException {
//		setCAFContext();				
	}
	public static synchronized IDataAccessService getDataAccessService(int origin)
		throws DataAccessException {
		//if (singletonDataAccessFactory == null) {
			//synchronized (DataAccessFactory.class) {
				if (singletonDataAccessFactory == null) {  //double checking
				singletonDataAccessFactory = new DataAccessFactory();
				}
			//}
		//}
		switch (origin) {
			case 1 :
				return JDODataAccessService.getInstance();
			case 2 :
				return RemoteDataAccessService.getInstance();
			case 3 :
				throw new DataAccessException("");
//				return KMDataAccessService.getInstance();
			case 4 :
				throw new DataAccessException("");
			case 5 :
				throw new DataAccessException("");
			case 6 :
				throw new DataAccessException("");
			default :
				throw new DataAccessException("");
		}
	}

/*	private void setCAFContext() throws DataAccessException {
		
		String cafCtx = "localejbs/com.sap.caf.runtime.CAFContext";
		CAFContextLocalHome beanHome = null;

		try {
			jndiCtx = new InitialContext();
			beanHome = (CAFContextLocalHome) jndiCtx.lookup(cafCtx);
			CAFContextLocal beanLocal = beanHome.create(); 	
			beanLocal.setCAFContext();
		} catch (Exception e) {
			throw new DataAccessException(e);
		}		
	}
*/
}
