/*
 * Created on 02-Jul-03
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.bol.context;

import java.lang.reflect.Method;
import java.util.Properties;

import javax.ejb.EJBLocalHome;
import javax.naming.Context;
import javax.naming.InitialContext;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author d025479
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class CAFProperties extends ApplicationProperties {
	//$JL-CLONE$
	private static final long serialVersionUID = 1;

	private static String JARM_REQUEST = "CAF:RT:oal";
	private static final Location location =
		Location.getLocation(CAFProperties.class);

	/**
	 * 
	 */
	public CAFProperties() {
		super();
	}

	/**
	 * @param defaults
	 */
	public CAFProperties(Properties defaults) {
		super(defaults);
	}

	public void loadApplicationProperties() throws DataAccessException {
		String method = "loadApplicationProperties()";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);

		ICAFConfig config = null;
		Properties props = null;
		try {
			Context ctx = new InitialContext();
			EJBLocalHome localHome =
				(EJBLocalHome) ctx.lookup(
					"localejbs/sap.com/caf.runtime/CAFConfig");
			Method meth =
				localHome.getClass().getDeclaredMethod("create", new Class[0]);
			config = (ICAFConfig) meth.invoke(localHome, new Object[0]);
			props = config.getConfiguration();
			if (props != null)
				super.putAll(props);
		} catch (Exception e) {
			Object[] args = { "localejbs/sap.com/caf.runtime/CAFConfig" };
			CAFPublicLogger.categoryCAF.logThrowableT(
				Severity.ERROR,
				location,
				method,
				"Error in loading CAF ApplicationProperties using config EJB : {0}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}
}
