/*
 * Created on 27.05.2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.bol.context;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
/**
 * @author D031666
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class CAFContext {
	public static String JNDI_NAME_JDO;
	public static String JNDI_NAME_JMS;
	public static String JNDI_NAME_JMS_TOPIC;
	public static boolean PUBLISH_ENABLED;
	public static boolean OPTIMISTIC_LOCKING_ENABLED;
	public static boolean DA_CACHE_ACTIVE;
	public static int DA_CACHE_SIZE;
	public static int DA_CACHE_LIFETIME;

	public static String KM_REPOSITORY;
	public static String KM_TMP_REPOSITORY_FOLDER;

	public static String KM_MACHINE_ADDRESS;
	public static int KM_MACHINE_PORT;
	public static String WAS_MACHINE_ADDRESS;
	public static int WAS_MACHINE_PORT;
	public static String JNDI_USER;
	public static String JNDI_PWD;
	public static boolean NOTIF_USE_DEPLOYED_SUBSCR;
	public static String JNDI_NAME_NOTIF_JMS_TOPIC;
	
	public static boolean DELETION_REGISTRATION_ENABLED;
	public static boolean CAF_BW_INTEGRATION_ENABLED;
	public static int     CAF_BW_SYSTEMS_TIMEZONE_DIFFERENCE;
	public static String  CAF_BW_DATASOURCE_NAME_PREFIX;
	public static String  CAF_BW_CLASSIFICATION_DATASOURCE_NAME_PREFIX;
	
	//private static ThreadLocal jARMMonitor = new ThreadLocal();
	private static final String jARMRequest = "CAF:RT:oal";
	private static final Location location =
		Location.getLocation(CAFContext.class);
	static {
		CAFPublicLogger.entering(
			null,
			jARMRequest,
			"static initialize block in CAFContext class",
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		CAFProperties props = new CAFProperties();
		try {
			props.loadApplicationProperties();
			JNDI_NAME_JDO =
				props.getProperty(
					"JNDI_NAME_JDO",
					"java:comp/env/jdo/defaultPMF");
			JNDI_NAME_JMS =
				props.getProperty(
					"JNDI_NAME_JMS",
					"jmsfactory/TopicConnectionFactory");
			JNDI_NAME_JMS_TOPIC =
				props.getProperty(
					"JNDI_NAME_JMS_TOPIC",
					"jmstopics/default/sapDemoTopic");
			DA_CACHE_ACTIVE =
				(new Boolean(props.getProperty("DA_CACHE_ACTIVE", "false")))
					.booleanValue();
			PUBLISH_ENABLED =
				(new Boolean(props.getProperty("PUBLISH_ENABLED", "true")))
					.booleanValue();
			OPTIMISTIC_LOCKING_ENABLED =
				(new Boolean(props.getProperty("OPTIMISTIC_LOCKING_ENABLED", "true")))
					.booleanValue();

			DA_CACHE_SIZE =
				(new Integer(props.getProperty("DA_CACHE_SIZE", "1000")))
					.intValue();
			DA_CACHE_LIFETIME =
				(new Integer(props.getProperty("DA_CACHE_LIFETIME", "900000")))
					.intValue();

			KM_REPOSITORY = props.getProperty("KM_REPOSITORY", "/caf");
			KM_TMP_REPOSITORY_FOLDER = props.getProperty("KM_TMP_REPOSITORY_FOLDER", "/documents_xapps");

			KM_MACHINE_ADDRESS =
				props.getProperty("KM_MACHINE_ADDRESS", "localhost");
			KM_MACHINE_PORT =
				(new Integer(props.getProperty("KM_MACHINE_PORT", "50000")))
					.intValue();
			NOTIF_USE_DEPLOYED_SUBSCR =
				(new Boolean(props.getProperty("NOTIF_USE_DEPLOYED_SUBSCR", "false")))
					.booleanValue();
			JNDI_NAME_NOTIF_JMS_TOPIC =	props.getProperty("JNDI_NAME_NOTIF_JMS_TOPIC", "jmstopics/default/CAFNotifTopic");
		
			WAS_MACHINE_ADDRESS = 
					props.getProperty("WAS_MACHINE_ADDRESS", "localhost");
			WAS_MACHINE_PORT = 
					(new Integer(props.getProperty("WAS_MACHINE_PORT", "50000"))).intValue();
					
			DELETION_REGISTRATION_ENABLED =
				(new Boolean(props.getProperty("DELETION_REGISTRATION_ENABLED", "false"))).booleanValue();
		
			CAF_BW_INTEGRATION_ENABLED = 
				(new Boolean(props.getProperty("CAF_BW_INTEGRATION_ENABLED", "false"))).booleanValue();
			CAF_BW_SYSTEMS_TIMEZONE_DIFFERENCE = 
					(new Integer(props.getProperty("CAF_BW_SYSTEMS_TIMEZONE_DIFFERENCE", "0"))).intValue();
			CAF_BW_DATASOURCE_NAME_PREFIX = props.getProperty("CAF_BW_DATASOURCE_NAME_PREFIX", "");
			CAF_BW_CLASSIFICATION_DATASOURCE_NAME_PREFIX = props.getProperty("CAF_BW_CLASSIFICATION_DATASOURCE_NAME_PREFIX", "C");			
		} catch (DataAccessException e1) {
			location.catching(
				CAFPublicLogger.categoryCAF,
				"static initialize block in CAFContext class",
				e1);
		} finally {
			CAFPublicLogger.exiting(
				null,
				jARMRequest,
				"static initialize block in CAFContext class",
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}
	public static IMonitor getMonitor(String user, String request) {
		//if (jARMMonitor.get() == null) 
		//jARMMonitor.set(TaskMonitor.getRequestMonitor(user, request));
		return TaskMonitor.getRequestMonitor(user, request);
		//return (IMonitor) jARMMonitor.get();
	}
	
	public static String substWASAddress(String templ) {
		return substHostPort(templ, "was_host", "was_port", WAS_MACHINE_ADDRESS, WAS_MACHINE_PORT);
	}	

	public static String substEPAddress(String templ) {
		return substHostPort(templ, "km_host", "km_port", KM_MACHINE_ADDRESS, KM_MACHINE_PORT);
	}

	private static String substHostPort(String template, String paramNameHost, String paramNamePort, 
		String valueHost, int valuePort) 
	{
		if (valueHost==null || valuePort==0 || template==null || template.length()==0) {
			return template;
		}
		StringBuffer sb = new StringBuffer(template.length()+valueHost.length()+4);
		int i;
		String s;
		s = paramNameHost;
		i = template.indexOf(s);
		if (i>-1) {
			template = sb.append(template.substring(0, i)).append(valueHost).append(template.substring(i+s.length())).toString();
		}
		sb.setLength(0);
		s = paramNamePort;
		i = template.indexOf(s);
		if (i>-1) {
			template = sb.append(template.substring(0, i)).append(valuePort).append(template.substring(i+s.length())).toString();
		}
		return template;
	}
    

}
