/*
 * Created on 02-Jul-03
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.bol.context;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.engine.services.configuration.appconfiguration.ApplicationConfigHandlerFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author d025479
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ApplicationProperties extends Properties {
	//$JL-CLONE$
	private static final long serialVersionUID = 1;

	private static String JARM_REQUEST = "CAF:RT:oal";
	private static final Location location =
		Location.getLocation(ApplicationProperties.class);

	public ApplicationProperties() {
		super();
	}

	public ApplicationProperties(Properties defaults) {
		super(defaults);
	}

	public void loadApplicationProperties() throws DataAccessException {
		String method = "loadApplicationProperties()";
		CAFPublicLogger.entering(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		Properties props = null;
		try {
			Context ctx = new InitialContext();
			ApplicationConfigHandlerFactory chf =
				(ApplicationConfigHandlerFactory) ctx.lookup(
					"ApplicationConfiguration");
			props = chf.getApplicationProperties();
			if (props != null)
				super.putAll(props);
		} catch (NamingException e) {
			Object[] args = { "ApplicationConfiguration" };
			CAFPublicLogger.categoryCAF.logThrowableT(
				Severity.ERROR,
				location,
				method,
				"NamingException in look up of Application Configuration : {0}",
				args,
				e);
			location.throwing(method, e);
			throw new DataAccessException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
		}

	}
}
