/*
 * Created on 16.09.2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.bol;

import java.util.Collection;

import com.sap.caf.rt.exception.BEException;

/**
 * @author d023389
 *
 * This interface contains the additional methods that must 
 * be implemented for a BO with KM persistency
 * 
 * Tthe interface provides methods for handling 
 * relations between KM objects and other objects
 * (including CAF objects).
 * These types of relations are implemented as KM relations
 * and are only created when a relation points from a KM object
 * to another object. For the opposite direction (CAF to KM), 
 * normal CAF relations are stored via JDO tables 
 * on the CAF object
 * 
 * This relation handling is required by two use cases:
 * 1) Index-Searching BOs by text in attached documents: 
 * 		Documents are issued by trex, corresponding BOs must be 
 * 		found
 * 2) Where-used functionality in general for KM BOs  
 */


public interface IKMExt  {


	public String getParentFolder();
	
	
	public void setParentFolder(String parentFolder);
	
	
	public String getDocumentId();
	
	
	public void setDocumentId(String documentId);	
	
	
	public void addRelatedObjectRids(java.lang.String relatedObjectRids);
	
	
	public void removeRelatedObjectRids(java.lang.String relatedObjectRids);
	
	
	public /*java.util.HashSet*/Collection getRelatedObjectRids();

}
