package com.sap.caf.rt.bol;

import java.util.List;

import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;
/**
 * This interface includes the standard properties any Business
 * Object must implement.
 */
public interface IDependentObject {

	/** 
	 * This method provides the Object key of the data object in a
	 * serialized form: <br>
	 * a unique string representation of the key for dependent objects <br>
	 * this is a GUID for all business objects
	 * 
	 * @return Object key
	*/
	public String getKey();

	public String getObjectType();
	/** This method provides a list of the names of all available 
	 * properties of the business object.
	 * @return List of property names (java.lang.String)
	 */
	public List getPropertyList();
	/** This method provides read access to the Business Object 
	 * properties. <p>
	 * @param propertyName Name of the property
	 * @return Property value as java.lang.Object
	 */
	public Object getProperty(String propertyName);
	/** This method provides write access to the Business Object 
	 * properties. <p>
	 * @param propertyName Name of the property
	 * @param propertyValue Value of the property
	 */
	public void setProperty(String propertyName, Object propertyValue);
	
	public AbstractPrimaryKey getPK();

}
