package com.sap.caf.rt.bol;

import java.util.Date;

/**
 * This interface includes the standard properties any Business
 * Object must implement and untyped methods to read and change
 * the Business Object properties. This interface is used in 
 * references between Business Objects. Applications that retrieve 
 * this interface from a Business Object reference should cast
 * the object to the own local interface of the Business Object (if known)
 * to get full access to its properties and methods.
 */
public interface IBusinessObject extends IDependentObject {

	/** @return User who created the Business Object 
	 * (com.sap.security.usermanagement.IUser)
	 */
	public String getCreatedBy();
	/** @return Date, when the Business Object was created */
	public Date getCreatedAt();
	/** @return Last user who changed the Business Object 
	 * (com.sap.security.usermanagement.IUser)
	 */
	public String getLastChangedBy();
	/** @return Date, when the Business Object was changed the last 
	 * time 
	 */
	public Date getLastChangedAt();
	/** @return type of the Business Object (JNDI name of the Entity Bean)
	 */
	public boolean validate();

	public String getRid();
}
