package com.sap.caf.rt.bol;

import com.sap.caf.rt.exception.BEException;
import com.sap.security.api.IPrincipal;
import java.util.Collection;
/**
 * This interface includes the standard properties any Business
 * Object must implement and untyped methods to read and change
 * the Business Object properties. This interface is used in 
 * references between Business Objects. Applications that retrieve 
 * this interface from a Business Object reference should cast
 * the object to the own local interface of the Business Object (if known)
 * to get full access to its properties and methods.
 */
public interface IAuthBusinessObject extends IBusinessObject {

  public void addPrincipalPermission(IPrincipal principal, String permission) throws BEException; 
  public void removePrincipalPermission(IPrincipal principal, String permission) throws BEException;
  public void addAuthUser(String userId, String permission) throws BEException;
  public void removeAuthUser(String userId, String permission) throws BEException;
  public Collection getAuthUser(String permission) throws BEException;

}
