/*
 * Created on May 10, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.rt.bol;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify;
import com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchSearch;
import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocalHome;
import com.sap.caf.km.ejb.svc.idxsearch.common.ClassifyException;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchResult;
import com.sap.caf.km.ejb.svc.idxsearch.common.SearchException;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.services.notify.notif.bobject.BOChangedPublisher;
import com.sap.caf.rt.services.publish.PublishingLocal;
import com.sap.caf.rt.services.publish.PublishingLocalHome;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author trendafil-m
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class EntityServiceBase implements IBusinessEntityService {

	protected BOChangedPublisher notifPub;
	protected SessionContext sessionContext;
	protected PublishingLocal pub;
	private static final Location location =
		Location.getLocation(EntityServiceBase.class);
	private static final String APPLICATION = EntityServiceBase.class.getName();
	private static final String JARM_REQUEST = "CAF:RT:BOL" + APPLICATION;
	private IIndexSearchSearch indexSearchSearch;
	private IIndexSearchClassify indexSearchClassify;
	private static final String KM_EAR_NAME =
		"localejbs/sap.com/caf~com.sap.caf.runtime";
	protected String _objectName;
	private static final String INDEX_SEARCH_BEAN_NAME = "IndexSearchBean";

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setSessionContext(SessionContext context) {
		sessionContext = context;
		if(CAFContext.PUBLISH_ENABLED) {
			notifPub	= new BOChangedPublisher(this);
		}			
	}

	protected void initPublishing() throws BEException {
		String method = "initPublishing()";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);

		try {
			Context ctx = new InitialContext();
			PublishingLocalHome home =
				(PublishingLocalHome) ctx.lookup(
					"localejbs/sap.com/caf.runtime/Publishing");
			pub = home.create();
		} catch (NamingException e) {
			Object[] args = { "localejbs/sap.com/caf.runtime/Publishing" };
			CAFPublicLogger.categoryCAF.logThrowableT(
				Severity.ERROR,
				location,
				method,
				"Error in JNDI lookup of {0}",
				args,
				e);
			location.throwing(method, e);
			throw new BEException(e);
		} catch (CreateException e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
			throw new BEException(e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}

	}

	protected Object[] getPublishingArgs(IBusinessObject object)
		throws Exception {
		String method = "getPublishingArgs(IBusinessObject)";
		CAFPublicLogger.entering(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { object.getKey()},
			CAFPublicLogger.LEVEL_MEDIUM);

		Object[] msgArgs = new Object[4];
		msgArgs[0] = object.getObjectType();
		msgArgs[1] = object.getKey();
		msgArgs[2] = object.getRid();
		msgArgs[3] = "";

		if(object instanceof IKMExt) {
			Iterator it = ((IKMExt)object).getRelatedObjectRids().iterator();
			if (it.hasNext()) {
			StringBuffer buffer = new StringBuffer(256);
			do  {
				buffer.append((String)it.next()).append(';');    
			} while(it.hasNext());
			buffer.setLength(buffer.length()-1);
			msgArgs[3] = buffer.toString();
			}
		 }

		CAFPublicLogger.exiting(
			null,
			JARM_REQUEST,
			method,
			location,
			new Object[] { msgArgs },
			CAFPublicLogger.LEVEL_MEDIUM);
		return msgArgs;
	}

	public IDependentObject createGeneric(List attributes)
		throws CAFCreateException {
		String user = sessionContext.getCallerPrincipal().getName();
		String method = "createGeneric(List)";
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { attributes },
			CAFPublicLogger.LEVEL_MEDIUM);
		int size = attributes.size();
		Class[] parameterTypes = new Class[size];
		Object[] args = new Object[size];
		Iterator iter = attributes.iterator();
		for (int i = 0; i < size; i++) {
			Object attribute = iter.next();
			parameterTypes[i] = attribute.getClass();
			args[i] = attribute;
		}
		IDependentObject result;
		try {
			Method createMethod =
				this.getClass().getMethod("create", parameterTypes);
			result = (IDependentObject) createMethod.invoke(this, args);
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(
				Severity.INFO,
				CAFPublicLogger.LOC_CAF,
				method,
				e);
			CAFPublicLogger.exiting(user, JARM_REQUEST, method, location);
			throw new CAFCreateException(e);
		}
		CAFPublicLogger.exiting(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { result },
			CAFPublicLogger.LEVEL_MEDIUM);
		return result;
	}

	public void deleteGeneric(IDependentObject object)
		throws CAFDeleteException {
		String user = sessionContext.getCallerPrincipal().getName();
		String method = "deleteGeneric(IDependentObject)";
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { object },
			CAFPublicLogger.LEVEL_MEDIUM);

		try {
			Method deleteMethod =
				this.getClass().getMethod(
					"delete",
					new Class[] { IDependentObject.class });
			deleteMethod.invoke(this, new Object[] { object });
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(
				Severity.INFO,
				CAFPublicLogger.LOC_CAF,
				method,
				e);
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
			throw new CAFDeleteException(e);
		}
		CAFPublicLogger.exiting(
			user,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
	}

	public Collection findGeneric(String operationName, List attributes)
		throws CAFFindException {
		String user = sessionContext.getCallerPrincipal().getName();
		String method = "findGeneric(String, List)";
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { operationName, attributes },
			CAFPublicLogger.LEVEL_MEDIUM);
		int size = attributes.size();
		Class[] parameterTypes = new Class[size];
		Object[] args = new Object[size];
		Iterator iter = attributes.iterator();
		for (int i = 0; i < size; i++) {
			Object attribute = iter.next();
			parameterTypes[i] = attribute.getClass();
			args[i] = attribute;
		}
		Collection result;
		try {
			Method findMethod =
				this.getClass().getMethod(operationName, parameterTypes);
			result = (Collection) findMethod.invoke(this, args);
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(
				Severity.INFO,
				CAFPublicLogger.LOC_CAF,
				method,
				e);
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
			throw new CAFFindException(e);
		}
		CAFPublicLogger.exiting(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { result },
			CAFPublicLogger.LEVEL_MEDIUM);
		return result;
	}

	public IDependentObject readGeneric(String key)
		throws CAFRetrieveException {
		String user = sessionContext.getCallerPrincipal().getName();
		String method = "readGeneric(String)";
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { key },
			CAFPublicLogger.LEVEL_MEDIUM);

		IDependentObject result;
		try {
			Method readMethod =
				this.getClass().getMethod("read", new Class[] { String.class });
			result =
				(IDependentObject) readMethod.invoke(
					this,
					new Object[] { key });
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(
				Severity.INFO,
				CAFPublicLogger.LOC_CAF,
				method,
				e);
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
			throw new CAFRetrieveException(e);
		}
		CAFPublicLogger.exiting(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { result },
			CAFPublicLogger.LEVEL_MEDIUM);
		return result;
	}

	public void updateGeneric(IDependentObject object)
		throws CAFUpdateException {
		String user = sessionContext.getCallerPrincipal().getName();
		String method = "updateGeneric(IDependentObject)";
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { object },
			CAFPublicLogger.LEVEL_MEDIUM);

		try {
			Method updateMethod =
				this.getClass().getMethod(
					"update",
					new Class[] { IDependentObject.class });
			updateMethod.invoke(this, new Object[] { object });
		} catch (Exception e) {
			CAFPublicLogger.traceThrowable(
				Severity.INFO,
				CAFPublicLogger.LOC_CAF,
				method,
				e);
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
			throw new CAFUpdateException(e);
		}
		CAFPublicLogger.exiting(
			user,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
	}

	/**
	 * Performs full text search by BO properties in KM index
	 * @param mapNameToFilter	A map of pairs: [nameOfAttribute, fullTextToBeSearchedFor] 
	 * @return A collection of BO keys
	 * @throws FinderException
	 * @throws CAFFindException
	 */
	public Collection findByKMPropertySearch(
		Map mapAttributeNameToFilter,
		Map mapCategoryNameToFilter)
		throws FinderException, CAFFindException {
		String method = "findByKMPropertySearch(Map, Map)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { mapAttributeNameToFilter, mapCategoryNameToFilter },
			CAFPublicLogger.LEVEL_MEDIUM);

		/* May the null pointer is correct??? May be method can return empty
		   collection???*/
		if (null == mapAttributeNameToFilter
			|| null == mapCategoryNameToFilter) {
			throw new CAFFindException(
				new NullPointerException("The Parameters of ejbFindByKMPropertySearch function could not be null."));
		}
		LinkedList keySet = new LinkedList();
		/* main body of find functionality. this code is duplicated for each find function. it is stupid. ???*/
		try {
			initIndexSearchContext();
			Collection resultSet =
				indexSearchSearch.searchForBO(
					mapAttributeNameToFilter,
					mapCategoryNameToFilter,
					_objectName);
			String sKey;
			ISearchResult result;
			Iterator iter = resultSet.iterator();
			while (iter.hasNext()) {
				result = (ISearchResult) iter.next();
				sKey = result.getBOGuid();
				if (sKey != null && sKey.length() > 0) {
					keySet.add(sKey);
				}
			}
		} catch (Exception ex) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				ex);
			location.throwing(method, ex);
			throw new CAFFindException("BO_FIND", ex);
		} finally {
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				new Object[] { keySet },
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return keySet;
	}

	/**
	 * Performs full text search by BO properties in KM index
	 * @param collectionFilters	A collection of filters
	 * @return A collection of BO keys
	 * @throws FinderException
	 * @throws CAFFindException
	 */
	public Collection findByKMPropertySearch(
		Collection collectionFilters
		)
		throws FinderException, CAFFindException {
		String method = "findByKMPropertySearch(Collection)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { collectionFilters },
			CAFPublicLogger.LEVEL_MEDIUM);

		/* May the null pointer is correct??? May be method can return empty
		   collection???*/
		if (null == collectionFilters) {
			throw new CAFFindException(
				new NullPointerException("The Parameter of ejbFindByKMPropertySearch function could not be null."));
		}
		LinkedList keySet = new LinkedList();
		/* main body of find functionality. this code is duplicated for each find function. it is stupid. ???*/
		try {
			initIndexSearchContext();
			Collection resultSet =
				indexSearchSearch.searchForBO(
					collectionFilters,
					_objectName);
			String sKey;
			ISearchResult result;
			Iterator iter = resultSet.iterator();
			while (iter.hasNext()) {
				result = (ISearchResult) iter.next();
				sKey = result.getBOGuid();
				if (sKey != null && sKey.length() > 0) {
					keySet.add(sKey);
				}
			}
		} catch (Exception ex) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				ex);
			location.throwing(method, ex);
			throw new CAFFindException("BO_FIND", ex);
		} finally {
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				new Object[] { keySet },
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return keySet;
	}

	// IDX	indexSearch (trex)
	private void initIndexSearchContext() throws BEException {
		String method = "initIndexSearchContext()";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			CAFPublicLogger.LEVEL_MEDIUM);
		if ((indexSearchSearch != null) && (indexSearchClassify != null)) {
			CAFPublicLogger.exiting(user, JARM_REQUEST, method, location);
			return;
		}
		try {
			Context context = new InitialContext();
			Context kmClientContext = (Context) context.lookup(KM_EAR_NAME);
			IndexSearchLocalHome indexSearchHome =
				(IndexSearchLocalHome) kmClientContext.lookup(
					INDEX_SEARCH_BEAN_NAME);
			indexSearchSearch = (IIndexSearchSearch) indexSearchHome.create();
			indexSearchClassify =
				(IIndexSearchClassify) indexSearchHome.create();

		} catch (NamingException ne) {
			Object[] args = { KM_EAR_NAME };
			CAFPublicLogger.categoryCAF.logThrowableT(
				Severity.ERROR,
				location,
				method,
				"Error in JNDI lookup of {0}",
				args,
				ne);
			location.throwing(method, ne);
			throw new BEException(ne.getMessage(), null, ne);
		} catch (CreateException ne) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				ne);
			location.throwing(method, ne);
			throw new BEException(ne.getMessage(), null, ne);
		} finally {
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public Collection searchidxForBOInRelatedDoc(String freeText)
		throws BEException {
		String method = "searchidxForBOInRelatedDoc(String)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { freeText },
			CAFPublicLogger.LEVEL_MEDIUM);

		Collection results = null;
		Collection finalResults = new LinkedList();
		Collection collAttributesAsString = new LinkedList();

		//make sure the context is created		
		initIndexSearchContext();
		//call function 
		try {
			results =
				indexSearchSearch.searchForBOInRelatedDoc(
					collAttributesAsString,
					freeText,
					_objectName);
		} catch (SearchException se) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				se);
			location.throwing(method, se);
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
			throw new BEException(se.getMessage(), null, se);
		}

		Iterator it = results.iterator();
		while (it.hasNext()) {
			finalResults.add((Object) ((ISearchResult) it.next()).getBOGuid());
		}

		CAFPublicLogger.exiting(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { finalResults },
			CAFPublicLogger.LEVEL_MEDIUM);
		return finalResults;
	}

	/**
	 * KM - searching method, searchidxForSimilar
	 * @param thisCourse, maxResults
	 * @return Collection 
	 * @throws BEException
	 */
	public Collection searchidxForSimilar(
		IBusinessObject object,
		int maxResults)
		throws BEException {
		String method = "searchidxForSimilar(IBusinessObject, int)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { object, new Integer(maxResults)},
			CAFPublicLogger.LEVEL_MEDIUM);

		Collection results = null;
		Collection finalResults = new LinkedList();

		//make sure the context is created		
		initIndexSearchContext();

		//call function 
		try {
			results =
				indexSearchSearch.searchForSimilarCAF(
					object.getRid(),
					maxResults);

		} catch (SearchException se) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				se);
			location.throwing(method, se);
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
			throw new BEException(se.getMessage(), null, se);
		}

		Iterator it = results.iterator();
		while (it.hasNext()) {
			finalResults.add((Object) ((ISearchResult) it.next()).getBOGuid());
		}

		CAFPublicLogger.exiting(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { finalResults },
			CAFPublicLogger.LEVEL_MEDIUM);
		return finalResults;
	}

	//classification methods

	/**
	 * KM - classification methods, getCategories
	 * @return Collection 
	 * @throws BEException
	 */
	public Collection getCategories() throws BEException {
		String method = "getCategories()";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			null,
			CAFPublicLogger.LEVEL_MEDIUM);

		Collection results = null;

		//make sure the context is created		
		initIndexSearchContext();

		//call function 
		try {
			results =
				indexSearchClassify.getCategories(this.getClass().getName());
		} catch (ClassifyException ce) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				ce);
			location.throwing(method, ce);
			throw new BEException(ce.getMessage(), null, ce);
		} finally {
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				new Object[] { results },
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return results;
	}

	/**
	 * KM - classification methods, getClassification
	 * @param boPrimaryKey, categoryGUID
	 * @return Collection 
	 * @throws BEException
	 */
	public Collection getClassification(
		String boPrimaryKey,
		String categoryGUID)
		throws BEException {
		String method = "getClassification(String,String)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { boPrimaryKey, categoryGUID },
			CAFPublicLogger.LEVEL_MEDIUM);

		Collection results = null;

		//make sure the context is created		
		initIndexSearchContext();

		//call function 
		try {
			results =
				indexSearchClassify.getClassification(
					boPrimaryKey,
					categoryGUID);
		} catch (ClassifyException ce) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				ce);
			location.throwing(method, ce);
			throw new BEException(ce.getMessage(), null, ce);
		} finally {
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				new Object[] { results },
				CAFPublicLogger.LEVEL_MEDIUM);
		}
		return results;
	}

	/**
	 * KM - classification methods, addClassification
	 * @param boPrimaryKey, valueGUID, categoryGUID
	 * @return void 
	 * @throws BEException
	 */
	public void addClassification(
		String boPrimaryKey,
		String valueGUID,
		String categoryGUID)
		throws BEException {
		String method = "addClassification(String, String, String)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { boPrimaryKey, valueGUID, categoryGUID },
			CAFPublicLogger.LEVEL_MEDIUM);

		//make sure the context is created		
		initIndexSearchContext();

		//call function 
		try {
			indexSearchClassify.addClassification(
				valueGUID,
				boPrimaryKey,
				categoryGUID);
		} catch (ClassifyException ce) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				ce);
			location.throwing(method, ce);
			throw new BEException(ce.getMessage(), null, ce);
		} finally {
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	/**
	 * KM - classification methods, removeClassification
	 * @param boPrimaryKey, valueGUID
	 * @return void 
	 * @throws BEException
	 */
	public void removeClassification(String boPrimaryKey, String valueGUID)
		throws BEException {
		String method = "removeClassification(String, String)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			JARM_REQUEST,
			method,
			location,
			new Object[] { boPrimaryKey, valueGUID },
			CAFPublicLogger.LEVEL_MEDIUM);

		//make sure the context is created		
		initIndexSearchContext();

		//call function 
		try {
			indexSearchClassify.removeClassification(valueGUID, boPrimaryKey);
		} catch (ClassifyException ce) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				ce);
			location.throwing(method, ce);
			throw new BEException(ce.getMessage(), null, ce);
		} finally {
			CAFPublicLogger.exiting(
				user,
				JARM_REQUEST,
				method,
				location,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}
}