/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_devel/src/com/sap/tc/jtools/jlint/jom/devel/wizards/JavaTestWizardPage.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.devel.wizards;

import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

public class JavaTestWizardPage extends WizardPage {

  private StringDialogField fPseudoCommentDialogField;
  private StringDialogField fResBundleCommentDialogField;

  public JavaTestWizardPage(String pageName) {
    super(pageName);
    setPageComplete(true);
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
   */
  public void createControl(Composite parent) {
    initializeDialogUnits(parent);
    Composite composite = new Composite(parent, SWT.NONE);
    int nColumns = 4;

    GridLayout layout = new GridLayout();
    layout.numColumns = nColumns;
    composite.setLayout(layout);

    fPseudoCommentDialogField = new StringDialogField();
    fPseudoCommentDialogField.setLabelText("pseudocomment ID");
    fPseudoCommentDialogField
      .setDialogFieldListener(new IDialogFieldListener() {
      public void dialogFieldChanged(DialogField field) {
        handlePseudoCommentChanged();
      }
    });

    fResBundleCommentDialogField = new StringDialogField();
    fResBundleCommentDialogField.setLabelText("resource bundle");
    fResBundleCommentDialogField
      .setDialogFieldListener(new IDialogFieldListener() {
      public void dialogFieldChanged(DialogField field) {
        handleResBundleChanged();
      }
    });

    createPseudoCommentControls(composite, nColumns);
    createResBundleControls(composite, nColumns);
    setControl(composite);
  }

  private void createPseudoCommentControls(Composite composite, int nColumns) {
    fPseudoCommentDialogField.doFillIntoGrid(composite, nColumns - 1);
    DialogField.createEmptySpace(composite);
    LayoutUtil.setWidthHint(
      fPseudoCommentDialogField.getTextControl(null),
      getMaxFieldWidth());
  }

  private void createResBundleControls(Composite composite, int nColumns) {
    fResBundleCommentDialogField.doFillIntoGrid(composite, nColumns - 1);
    DialogField.createEmptySpace(composite);
    LayoutUtil.setWidthHint(
      fResBundleCommentDialogField.getTextControl(null),
      getMaxFieldWidth());
  }

  private int getMaxFieldWidth() {
    return convertWidthInCharsToPixels(40);
  }

  private void handlePseudoCommentChanged() {
    String commentId = fPseudoCommentDialogField.getText().trim();
    boolean commentOk = commentId.equals(commentId.toUpperCase());
    setPageComplete(commentOk);
    if (!commentOk)
      setErrorMessage("must be uppercase");
    else
      setErrorMessage(null);
  }

  private void handleResBundleChanged() {
    // TODO
  }

  public String getResourceBundleName() {
    return fResBundleCommentDialogField.getText().trim();
  }

  public String getPseudoCommentName() {
    return fPseudoCommentDialogField.getText().trim();
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.wizard.IWizardPage#canFlipToNextPage()
   */
  public boolean canFlipToNextPage() {
    return false; // last page
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.wizard.IWizardPage#getNextPage()
   */
  public IWizardPage getNextPage() {
    return null; // last page
  }

}
