/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_devel/src/com/sap/tc/jtools/jlint/jom/devel/wizards/JavaMetricWizardPage.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.devel.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

public class JavaMetricWizardPage extends WizardPage {

  private static String[] STATISTIC_NAMES =
    new String[] { "Sum", "Average", "Max", "Min", "Standard Deviation" };

  private StringDialogField fMetricNames;
  private SelectionButtonDialogFieldGroup fStatistics;

  public JavaMetricWizardPage(String pageName) {
    super(pageName);
    setPageComplete(true);
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
   */
  public void createControl(Composite parent) {
    initializeDialogUnits(parent);
    Composite composite = new Composite(parent, SWT.NONE);
    int nColumns = 4;

    GridLayout layout = new GridLayout();
    layout.numColumns = nColumns;
    composite.setLayout(layout);

    fMetricNames = new StringDialogField();
    fMetricNames.setLabelText("metric name(s) [comma-separated]");
    fMetricNames.doFillIntoGrid(composite, nColumns );

    fStatistics =
      new SelectionButtonDialogFieldGroup(SWT.CHECK, STATISTIC_NAMES, 1);
    fStatistics.setLabelText("Statistics");
    // select average, min and max by default
    fStatistics.setSelection(0, true);
    fStatistics.setSelection(2, true);
    fStatistics.setSelection(3, true);
    createStatisticsControls(composite, nColumns);
    setControl(composite);
  }

  private void createStatisticsControls(Composite composite, int nColumns) {
    fStatistics.doFillIntoGrid(composite, nColumns);
    DialogField.createEmptySpace(composite);
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.wizard.IWizardPage#canFlipToNextPage()
   */
  public boolean canFlipToNextPage() {
    return false; // last page
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.wizard.IWizardPage#getNextPage()
   */
  public IWizardPage getNextPage() {
    return null; // last page
  }

  public String getStatistics() {
    StringBuffer buf = new StringBuffer();
    boolean first = true;
    for (int i = 0; i < STATISTIC_NAMES.length; i++) {
      if (fStatistics.isSelected(i)) {
        String add;
        switch (i) {
          case 0 :
            add = "MetricInfo.SUM";
            break;
          case 1 :
            add = "MetricInfo.AVERAGE";
            break;
          case 2 :
            add = "MetricInfo.MAX";
            break;
          case 3 :
            add = "MetricInfo.MIN";
            break;
          case 4 :
            add = "MetricInfo.STD_DEV";
            break;
          default :
            add = null;
            break;
        }
        if (add != null) {
          buf.append(first ? add : " | " + add);
          first = false;
        }
      }
    }
    return buf.toString();
  }

  public String[] getMetricNames() {
    StringTokenizer tok = new StringTokenizer(fMetricNames.getText(), ",", false); //$NON-NLS-1$
    List metricNames = new ArrayList();
    while (tok.hasMoreTokens()) {
      metricNames.add(tok.nextToken().trim());
    }
    return (String[]) metricNames.toArray(new String[0]);
  }

}
