/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_devel/src/com/sap/tc/jtools/jlint/jom/devel/JavaTestGenerator.java#3 $
 */

package com.sap.tc.jtools.jlint.jom.devel;

import org.eclipse.jface.wizard.IWizardPage;

import com.sap.tc.jtools.jlint.eclipse.devel.extension.AbstractTestGenerator;
import com.sap.tc.jtools.jlint.java.JavaFileArrayTestObject;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.devel.wizards.JavaTestWizardPage;
import com.sap.tc.jtools.jlint.jom.eclipse.JomPlugin;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;

/**
 * TODO: description of this class/interface 
 * @author D037913
 */
public class JavaTestGenerator extends AbstractTestGenerator {

  private static final String SUPER_CLASS = JomTestVisitor.class.getName();

  private JavaTestWizardPage additionalPage = new JavaTestWizardPage("test");

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getTestObjectType()
   */
  public String getTestObjectType() {
    return JavaFileArrayTestObject.JAVA_FILE_LIST;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getSuperClass()
   */
  public String getSuperClass() {
    return SUPER_CLASS;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#wizardFinished()
   */
  public void wizardFinished() {
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getAdditionalPages()
   */
  public IWizardPage[] getAdditionalPages() {
    return new IWizardPage[] { additionalPage };
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getInternalParameters()
   */
  public ParameterInterface[] getInternalParameters() {
    String psCmt = additionalPage.getPseudoCommentName();
    if ("".equals(psCmt)) { //$NON-NLS-1$
      return new ParameterInterface[0];
    } else {
      return new ParameterInterface[] {
         ParameterTool.createParameter(
          JomTestVisitor.PARAMETER_PSEUDO_COMMENT_SUFFIX,
          ParameterTool.PAR_TYPE_STRING,
          psCmt)};
    }
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.AbstractTestGenerator#getResourceBundle()
   */
  protected String getResourceBundle() {
    String resBundle = additionalPage.getResourceBundleName();
    return "".equals(resBundle) ? null : resBundle; //$NON-NLS-1$
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getRequiredPluginIds()
   */
  public String[] getRequiredPluginIds() {
    return new String[] { JomPlugin.getDefault().getDescriptor()
        .getUniqueIdentifier() };
  }

}
