/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_devel/src/com/sap/tc/jtools/jlint/jom/devel/JavaMetricGenerator.java#3 $
 */
package com.sap.tc.jtools.jlint.jom.devel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import com.sap.tc.jtools.jlint.eclipse.devel.extension.AbstractTestGenerator;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jlint.java.JavaFileArrayTestObject;
import com.sap.tc.jtools.jlint.jom.devel.wizards.JavaMetricWizardPage;
import com.sap.tc.jtools.jlint.jom.eclipse.JomPlugin;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.Metric;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;

/**
 * TODO: description of this class/interface
 * 
 * @author D037913
 */
public class JavaMetricGenerator extends AbstractTestGenerator {

  private static final String  SUPER_CLASS            = JomMetricVisitor.class
                                                          .getName();
  private static String        METRICS_METHOD         = "\nprotected MetricInfo[] getMetricInfos() { return metrics; }\n";
  private static final String  METRICS_FIELD_FRAGMENT = "private static final MetricInfo[] metrics = new MetricInfo[] {";
  public static String         METRIC_RES_BUNDLE      = "com.sap.tc.jtools.jlint.tests.metrics.resources.Messages";
  private JavaMetricWizardPage additionalPage         = new JavaMetricWizardPage(
                                                          "metric");

  /*
   * (non-Javadoc)
   * 
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getTestObjectType()
   */
  public String getTestObjectType() {
    return JavaFileArrayTestObject.JAVA_FILE_LIST;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getSuperClass()
   */
  public String getSuperClass() {
    return SUPER_CLASS;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#wizardFinished()
   */
  public void wizardFinished() {
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getAdditionalPages()
   */
  public IWizardPage[] getAdditionalPages() {
    return new IWizardPage[]{additionalPage};
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#createTypeMembers(org.eclipse.jdt.core.IType)
   */
  public void createTypeMembers(IType testclass,
      NewTypeWizardPage.ImportsManager imports) {
    String stat = additionalPage.getStatistics();
    if ("".equals(stat))
      stat = "MetricInfo.AVERAGE | MetricInfo.MAX | MetricInfo.MIN "; //$NON-NLS-1$
    try {
      imports.addImport(MetricInfo.class.getName()); //$NON-NLS-1$
      testclass.createMethod(METRICS_METHOD, null, true, null);
      String[] metricNames = additionalPage.getMetricNames();
      StringBuffer metricsFieldContent = new StringBuffer(
          METRICS_FIELD_FRAGMENT);
      for (int i = 0; i < metricNames.length; i++) {
        if (i > 0) {
          metricsFieldContent.append(", ");
        }
        metricsFieldContent.append(" new MetricInfo(\"" + metricNames[i]
            + "\", " + stat + ")");
      }
      metricsFieldContent.append("};\n\n");
      testclass.createField(metricsFieldContent.toString(), null, true, null);
    } catch (JavaModelException e) {
      ExceptionHandler.handle(e);
    }
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.AbstractTestGenerator#getResourceBundle()
   */
  protected String getResourceBundle() {
    return METRIC_RES_BUNDLE;
  }

  private ParameterInterface[] createLevelParams(String metricName) {
    String upCaseName = metricName.toUpperCase();
    ParameterInterface[] params = new ParameterInterface[3];
    params[0] = ParameterTool.createParameter(upCaseName
        + Metric.PARAM_INFO_LEVEL_SUFFIX, ParameterTool.PAR_TYPE_FLOAT, null); //$NON-NLS-1$
    params[1] = ParameterTool
        .createParameter(upCaseName + Metric.PARAM_WARNING_LEVEL_SUFFIX,
            ParameterTool.PAR_TYPE_FLOAT, null); //$NON-NLS-1$
    params[2] = ParameterTool.createParameter(upCaseName
        + Metric.PARAM_ERROR_LEVEL_SUFFIX, ParameterTool.PAR_TYPE_FLOAT, null); //$NON-NLS-1$
    return params;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.AbstractTestGenerator#getInputParameters()
   */
  protected ParameterInterface[] getAdditionalInputParameters() {
    String[] metricNames = additionalPage.getMetricNames();
    List params = new ArrayList();
    for (int i = 0; i < metricNames.length; i++) {
      params.addAll(Arrays.asList(createLevelParams(metricNames[i])));
    }
    return (ParameterInterface[]) params.toArray(new ParameterInterface[0]);
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.sap.tc.jtools.jlint.eclipse.devel.extension.ITestGenerator#getRequiredPluginIds()
   */
  public String[] getRequiredPluginIds() {
    return new String[] { JomPlugin.getDefault().getDescriptor()
        .getUniqueIdentifier() };
  }
}