/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.util;

import java.util.List;


/**
 * List that informs about changes. See documentation of listener interface and event 
 * object for more information about the available notifications.
 * This type can be called, extended or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Frank Weigel
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/util/ICMIObservableList.java#1 $
 */
public interface ICMIObservableList extends List {

  /**
   * registeres the given listener. Thel istener will be notified 
   * about any modification of this list.
   */
  void addChangeListener(ICMIObservableListChangeListener listener);
  
  /**
   * registeres the given listener. Thel istener will be notified 
   * about any modification of this list.
   */
  void removeChangeListener(ICMIObservableListChangeListener listener);
  
}
