/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.util;

/**
 * Interface for classes which support tracking of modifications. <p>
 * 
 * Classes that implement this interface can take part in a more 
 * elaborated delta handling. So for model classes for instance the Web Dynpro framework
 * uses this interface to determine, which data has changed and must therefore be
 * sent to the client.
 * In order to support this, a class must
 * provide a counter, which is incremented upon each change. Usually this should be done
 * in a framework that implements this interface in a super class. <p> 
 * 
 * Frameworks evaluating this interface can maintain a
 * last counter state and compare it with the
 * current counter state to determine, whether the object has been
 * modified. Since overflows are possible and the access to the a
 * <code>long</code> as returned by the {@link #modCount()} is not atomic,
 * the frameworks using this interface must test for (in)equality and 
 * NOT if the new counter state is greater than the old one. <p>   
 * 
 * This interface is not meant for use by application developers.
 * However this type can be called, extended or implemented by frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Markus Cherdron, Stephan Ritter
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/util/ICMIModificationCount.java#1 $
 */
public interface ICMIModificationCount
{
  /**
   * Returns the current state of the modification counter. <p>
   * 
   * The counter is incremented upon each change of state of the current object 
   * (e.g. when a set, add or remove method is called on the object). 
   * The counter value MUST not be negative ( modCount>=0 ). If the counter overflows
   * then it must be reset to 0. This allows users to maintain an unitialized count by
   * holding an initially negative value. <p>
   * 
   * This concept assumes that the possibility to get the same counter value although the object has changed
   * is neoverflow is neglectible.
   */
  public long modCount();
}
