/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.metadata;

import java.util.Collection;


/**
 * Represents the metadata of a model relation at runtime.
 * CMI clients should work even if there is no implementation available for a
 * model as long as the appropriate relation role infos are available at runtime.
 * This type can be called, extended or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Markus Cherdron, Stephan Ritter
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/metadata/ICMIRelationInfo.java#1 $
 */
public interface ICMIRelationInfo extends ICMIAbstractInfo {	
	
    /**
     * returns the model info of the model to which this relation belongs.
     */
    ICMIModelInfo getModelInfo();

    /**
     * @clientCardinality 0..1
     * @supplierCardinality 2
     * @label / & optional 
     */
    /*# ICMIRelationRoleInfo lnkICMIlRelationRoleInfo; */

    /**
     * returns a collection with the role infos of two relation roles
     * which belong to the relation
     * The collection should be immutable.
     */
    Collection getRoleInfos();
}
