/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.metadata;

/**
 * Instances of this class represent 
 * a setting that the metadata of a model element (like {@link ICMIModelInfo}, 
 * {@link ICMIModelClassInfo}, {@link ICMIModelClassPropertyInfo}, {@link ICMIRelationInfo} or 
 * {@link ICMIRelationRoleInfo}) can have.
 * Each <code>CMISetting</code> is associated to a {@link CMISettingDefinition}.
 * This type can be called or extended by applications or frameworks using CMI.
 * 
 * @SAPCMIPart 1 
 * @author Markus Cherdron
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/metadata/CMISetting.java#1 $
 */
public class CMISetting
{
    /**
     * @supplierCardinality 1 
     */
    private CMISettingDefinition settingDef;
    private String value;

    /**
     * protected constructor
     */
    protected CMISetting(CMISettingDefinition settingDef, String value)
    {
      this.settingDef = settingDef;
      this.value = value;
    }

    /**
     * returns the CMISettingDefinition
     */
    public CMISettingDefinition getSettingDefinition()
    {
      return settingDef;
    }

    /**
     * returns the value of the CMISetting
     */
    public String getValue()
    {
      return value;
    }

    /**
     * returns a String representation of the CMISetting object in the form "SettingDefinition: Setting"
     */
    public String toString()
    {
      return settingDef + ": " + value;
    }

}
