/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.metadata;


/**
 * Instances of this Enumeration Class represent the type of a model.
 * This type can be called or extendeded by applications or frameworks using CMI.
 * 
 * @SAPCMIPart 1 
 * @author Markus Cherdron, Stephan Ritter
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/metadata/CMIModelType.java#1 $
 */
public class CMIModelType
{
    private String type;

    protected CMIModelType(String type)
    {
      this.type = type;
    }

    /**
     * returns a string representation of the model type
     */
    public String toString()
    {
      return type;
    }

}
