/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.repository.service/60NW_SP_COR/src/_appproperties/java/api/com/sapportals/wcm/repository/service/appproperties/IAppPropertyMap.java#3 $
 */

package com.sapportals.wcm.repository.service.appproperties;

import com.sapportals.wcm.repository.IPropertyName;

/**
 * A read-only map of application properties.
 * <p>
 * Copyright (c) SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 * @version $Revision: #3 $
 */
public interface IAppPropertyMap {

  /**
   * Returns the number of properties in the map
   *
   * @return The number of properties
   */
  public int size();

  /**
   * Returns true if the map is emptry
   *
   * @return true if the map is emptry
   */
  public boolean isEmpty();

  /**
   * Returns true if the map contains the property
   *
   * @param propertyName The property name to check for
   * @return true if the map contains the property
   */
  public boolean containsProperty(IPropertyName propertyName);

  /**
   * Get a property from the map
   *
   * @param propertyName The property name
   * @return The property
   */
  public IAppProperty get(IPropertyName propertyName);

  /**
   * Returns an iterator for the property map
   *
   * @return an iterator for the property map
   */
  public IAppPropertyIterator iterator();
}

