/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.repository.service/60NW_SP_COR/src/_appproperties/java/api/com/sapportals/wcm/repository/service/appproperties/IAppPropertyIterator.java#3 $
 */

package com.sapportals.wcm.repository.service.appproperties;

/**
 * An Iterator for an application property map.
 * <p>
 * Copyright (c) SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 */
public interface IAppPropertyIterator {

  /**
   * True if next() can be called
   *
   * @return Boolean value
   */
  public boolean hasNext();

  /**
   * Returns the next property in the map
   *
   * @return The property
   */
  public IAppProperty next();

  /**
   * Removes a property from the property map
   */
  //public void remove();

}

