/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.repository.service/60NW_SP_COR/src/_appproperties/java/api/com/sapportals/wcm/repository/service/appproperties/IAppPropertyCollection.java#3 $
 */

package com.sapportals.wcm.repository.service.appproperties;


/**
 * A read-only collection of application properties
 *
 * Copyright (c) SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 * @version $Revision: #3 $
 */
public interface IAppPropertyCollection {

  /**
   * Returns the number of properties in the set
   *
   * @return the number of properties in the set
   */
  public int size();

  /**
   * Returns true if the collection is emptry
   *
   * @return true if the collection is emptry
   */
  public boolean isEmpty();

  /**
   * Returns an iterator for the property collection
   *
   * @return an iterator for the property collection
   */
  public IAppPropertyIterator iterator();
}

